<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for FlagResponse StructType
 * @subpackage Structs
 */
class FlagResponse extends Response
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Value;

    /**
     * Constructor method for FlagResponse
     * @param bool $value
     * @uses FlagResponse::setValue()
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }

    /**
     * Get Value value
     * @return bool
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param bool $value
     * @return FlagResponse
     */
    public function setValue($value = null)
    {
        // validation for constraint: boolean
        if (!is_null($value) && !is_bool($value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
