<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancialAccountType StructType
 * @subpackage Structs
 */
class FinancialAccountType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CurrencyCode
     * @var CurrencyCodeType
     */
    public $CurrencyCode;
    /**
     * The PaymentNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentNote
     * @var PaymentNoteType
     */
    public $PaymentNote;
    /**
     * The FinancialInstitutionBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BranchType
     */
    public $FinancialInstitutionBranch;

    /**
     * Constructor method for FinancialAccountType
     * @param IDType $iD
     * @param CurrencyCodeType $currencyCode
     * @param PaymentNoteType $paymentNote
     * @param BranchType $financialInstitutionBranch
     * @uses FinancialAccountType::setID()
     * @uses FinancialAccountType::setCurrencyCode()
     * @uses FinancialAccountType::setPaymentNote()
     * @uses FinancialAccountType::setFinancialInstitutionBranch()
     */
    public function __construct(IDType $iD = null, CurrencyCodeType $currencyCode = null, PaymentNoteType $paymentNote = null, BranchType $financialInstitutionBranch = null)
    {
        $this
            ->setID($iD)
            ->setCurrencyCode($currencyCode)
            ->setPaymentNote($paymentNote)
            ->setFinancialInstitutionBranch($financialInstitutionBranch);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return FinancialAccountType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get CurrencyCode value
     * @return CurrencyCodeType|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }

    /**
     * Set CurrencyCode value
     * @param CurrencyCodeType $currencyCode
     * @return FinancialAccountType
     */
    public function setCurrencyCode(CurrencyCodeType $currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }

    /**
     * Get PaymentNote value
     * @return PaymentNoteType|null
     */
    public function getPaymentNote()
    {
        return $this->PaymentNote;
    }

    /**
     * Set PaymentNote value
     * @param PaymentNoteType $paymentNote
     * @return FinancialAccountType
     */
    public function setPaymentNote(PaymentNoteType $paymentNote = null)
    {
        $this->PaymentNote = $paymentNote;
        return $this;
    }

    /**
     * Get FinancialInstitutionBranch value
     * @return BranchType|null
     */
    public function getFinancialInstitutionBranch()
    {
        return $this->FinancialInstitutionBranch;
    }

    /**
     * Set FinancialInstitutionBranch value
     * @param BranchType $financialInstitutionBranch
     * @return FinancialAccountType
     */
    public function setFinancialInstitutionBranch(BranchType $financialInstitutionBranch = null)
    {
        $this->FinancialInstitutionBranch = $financialInstitutionBranch;
        return $this;
    }
}
