<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for DocumentResponseStatusResponse StructType
 * @subpackage Structs
 */
class DocumentResponseStatusResponse extends Response
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DocumentResponseStatusInfo[]
     */
    public $Value;

    /**
     * Constructor method for DocumentResponseStatusResponse
     * @param DocumentResponseStatusInfo[] $value
     * @uses DocumentResponseStatusResponse::setValue()
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }

    /**
     * Get Value value
     * @return DocumentResponseStatusInfo[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentResponseStatusResponseValueItem) {
            // validation for constraint: itemType
            if (!$documentResponseStatusResponseValueItem instanceof DocumentResponseStatusInfo) {
                $invalidValues[] = is_object($documentResponseStatusResponseValueItem) ? get_class($documentResponseStatusResponseValueItem) : sprintf('%s(%s)', gettype($documentResponseStatusResponseValueItem), var_export($documentResponseStatusResponseValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \Gek\UyumBahceGet\StructType\DocumentResponseStatusInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Value value
     * @param DocumentResponseStatusInfo[] $value
     * @return DocumentResponseStatusResponse
     * @throws InvalidArgumentException
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }

    /**
     * Add item to Value value
     * @param DocumentResponseStatusInfo $item
     * @return DocumentResponseStatusResponse
     * @throws InvalidArgumentException
     */
    public function addToValue(DocumentResponseStatusInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentResponseStatusInfo) {
            throw new InvalidArgumentException(sprintf('The Value property can only contain items of type \Gek\UyumBahceGet\StructType\DocumentResponseStatusInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
