<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DicKeyValues StructType
 * @subpackage Structs
 */
class DicKeyValues extends AbstractStructBase
{
    /**
     * The DicKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DicKey;
    /**
     * The DicValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DicValue;

    /**
     * Constructor method for DicKeyValues
     * @param string $dicKey
     * @param string $dicValue
     * @uses DicKeyValues::setDicKey()
     * @uses DicKeyValues::setDicValue()
     */
    public function __construct($dicKey = null, $dicValue = null)
    {
        $this
            ->setDicKey($dicKey)
            ->setDicValue($dicValue);
    }

    /**
     * Get DicKey value
     * @return string|null
     */
    public function getDicKey()
    {
        return $this->DicKey;
    }

    /**
     * Set DicKey value
     * @param string $dicKey
     * @return DicKeyValues
     */
    public function setDicKey($dicKey = null)
    {
        // validation for constraint: string
        if (!is_null($dicKey) && !is_string($dicKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dicKey, true), gettype($dicKey)), __LINE__);
        }
        $this->DicKey = $dicKey;
        return $this;
    }

    /**
     * Get DicValue value
     * @return string|null
     */
    public function getDicValue()
    {
        return $this->DicValue;
    }

    /**
     * Set DicValue value
     * @param string $dicValue
     * @return DicKeyValues
     */
    public function setDicValue($dicValue = null)
    {
        // validation for constraint: string
        if (!is_null($dicValue) && !is_string($dicValue)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dicValue, true), gettype($dicValue)), __LINE__);
        }
        $this->DicValue = $dicValue;
        return $this;
    }
}
