<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchType StructType
 * @subpackage Structs
 */
class DespatchType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The ActualDespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ActualDespatchDate
     * @var ActualDespatchDateType
     */
    public $ActualDespatchDate;
    /**
     * The ActualDespatchTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ActualDespatchTime
     * @var ActualDespatchTimeType
     */
    public $ActualDespatchTime;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Instructions
     * @var InstructionsType
     */
    public $Instructions;
    /**
     * The DespatchAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddressType
     */
    public $DespatchAddress;
    /**
     * The DespatchParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $DespatchParty;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ContactType
     */
    public $Contact;
    /**
     * The EstimatedDespatchPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PeriodType
     */
    public $EstimatedDespatchPeriod;

    /**
     * Constructor method for DespatchType
     * @param IDType $iD
     * @param ActualDespatchDateType $actualDespatchDate
     * @param ActualDespatchTimeType $actualDespatchTime
     * @param InstructionsType $instructions
     * @param AddressType $despatchAddress
     * @param PartyType $despatchParty
     * @param ContactType $contact
     * @param PeriodType $estimatedDespatchPeriod
     * @uses DespatchType::setID()
     * @uses DespatchType::setActualDespatchDate()
     * @uses DespatchType::setActualDespatchTime()
     * @uses DespatchType::setInstructions()
     * @uses DespatchType::setDespatchAddress()
     * @uses DespatchType::setDespatchParty()
     * @uses DespatchType::setContact()
     * @uses DespatchType::setEstimatedDespatchPeriod()
     */
    public function __construct(IDType $iD = null, ActualDespatchDateType $actualDespatchDate = null, ActualDespatchTimeType $actualDespatchTime = null, InstructionsType $instructions = null, AddressType $despatchAddress = null, PartyType $despatchParty = null, ContactType $contact = null, PeriodType $estimatedDespatchPeriod = null)
    {
        $this
            ->setID($iD)
            ->setActualDespatchDate($actualDespatchDate)
            ->setActualDespatchTime($actualDespatchTime)
            ->setInstructions($instructions)
            ->setDespatchAddress($despatchAddress)
            ->setDespatchParty($despatchParty)
            ->setContact($contact)
            ->setEstimatedDespatchPeriod($estimatedDespatchPeriod);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return DespatchType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get ActualDespatchDate value
     * @return ActualDespatchDateType|null
     */
    public function getActualDespatchDate()
    {
        return $this->ActualDespatchDate;
    }

    /**
     * Set ActualDespatchDate value
     * @param ActualDespatchDateType $actualDespatchDate
     * @return DespatchType
     */
    public function setActualDespatchDate(ActualDespatchDateType $actualDespatchDate = null)
    {
        $this->ActualDespatchDate = $actualDespatchDate;
        return $this;
    }

    /**
     * Get ActualDespatchTime value
     * @return ActualDespatchTimeType|null
     */
    public function getActualDespatchTime()
    {
        return $this->ActualDespatchTime;
    }

    /**
     * Set ActualDespatchTime value
     * @param ActualDespatchTimeType $actualDespatchTime
     * @return DespatchType
     */
    public function setActualDespatchTime(ActualDespatchTimeType $actualDespatchTime = null)
    {
        $this->ActualDespatchTime = $actualDespatchTime;
        return $this;
    }

    /**
     * Get Instructions value
     * @return InstructionsType|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }

    /**
     * Set Instructions value
     * @param InstructionsType $instructions
     * @return DespatchType
     */
    public function setInstructions(InstructionsType $instructions = null)
    {
        $this->Instructions = $instructions;
        return $this;
    }

    /**
     * Get DespatchAddress value
     * @return AddressType|null
     */
    public function getDespatchAddress()
    {
        return $this->DespatchAddress;
    }

    /**
     * Set DespatchAddress value
     * @param AddressType $despatchAddress
     * @return DespatchType
     */
    public function setDespatchAddress(AddressType $despatchAddress = null)
    {
        $this->DespatchAddress = $despatchAddress;
        return $this;
    }

    /**
     * Get DespatchParty value
     * @return PartyType|null
     */
    public function getDespatchParty()
    {
        return $this->DespatchParty;
    }

    /**
     * Set DespatchParty value
     * @param PartyType $despatchParty
     * @return DespatchType
     */
    public function setDespatchParty(PartyType $despatchParty = null)
    {
        $this->DespatchParty = $despatchParty;
        return $this;
    }

    /**
     * Get Contact value
     * @return ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }

    /**
     * Set Contact value
     * @param ContactType $contact
     * @return DespatchType
     */
    public function setContact(ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }

    /**
     * Get EstimatedDespatchPeriod value
     * @return PeriodType|null
     */
    public function getEstimatedDespatchPeriod()
    {
        return $this->EstimatedDespatchPeriod;
    }

    /**
     * Set EstimatedDespatchPeriod value
     * @param PeriodType $estimatedDespatchPeriod
     * @return DespatchType
     */
    public function setEstimatedDespatchPeriod(PeriodType $estimatedDespatchPeriod = null)
    {
        $this->EstimatedDespatchPeriod = $estimatedDespatchPeriod;
        return $this;
    }
}
