<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryType StructType
 * @subpackage Structs
 */
class DeliveryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Quantity
     * @var QuantityType
     */
    public $Quantity;
    /**
     * The ActualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ActualDeliveryDate
     * @var ActualDeliveryDateType
     */
    public $ActualDeliveryDate;
    /**
     * The ActualDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ActualDeliveryTime
     * @var ActualDeliveryTimeType
     */
    public $ActualDeliveryTime;
    /**
     * The LatestDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LatestDeliveryDate
     * @var LatestDeliveryDateType
     */
    public $LatestDeliveryDate;
    /**
     * The LatestDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LatestDeliveryTime
     * @var LatestDeliveryTimeType
     */
    public $LatestDeliveryTime;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TrackingID
     * @var TrackingIDType
     */
    public $TrackingID;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddressType
     */
    public $DeliveryAddress;
    /**
     * The AlternativeDeliveryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LocationType
     */
    public $AlternativeDeliveryLocation;
    /**
     * The EstimatedDeliveryPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PeriodType
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The CarrierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $CarrierParty;
    /**
     * The DeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $DeliveryParty;
    /**
     * The Despatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DespatchType
     */
    public $Despatch;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ShipmentType
     */
    public $Shipment;

    /**
     * Constructor method for DeliveryType
     * @param IDType $iD
     * @param QuantityType $quantity
     * @param ActualDeliveryDateType $actualDeliveryDate
     * @param ActualDeliveryTimeType $actualDeliveryTime
     * @param LatestDeliveryDateType $latestDeliveryDate
     * @param LatestDeliveryTimeType $latestDeliveryTime
     * @param TrackingIDType $trackingID
     * @param AddressType $deliveryAddress
     * @param LocationType $alternativeDeliveryLocation
     * @param PeriodType $estimatedDeliveryPeriod
     * @param PartyType $carrierParty
     * @param PartyType $deliveryParty
     * @param DespatchType $despatch
     * @param DeliveryTermsType[] $deliveryTerms
     * @param ShipmentType $shipment
     * @uses DeliveryType::setID()
     * @uses DeliveryType::setQuantity()
     * @uses DeliveryType::setActualDeliveryDate()
     * @uses DeliveryType::setActualDeliveryTime()
     * @uses DeliveryType::setLatestDeliveryDate()
     * @uses DeliveryType::setLatestDeliveryTime()
     * @uses DeliveryType::setTrackingID()
     * @uses DeliveryType::setDeliveryAddress()
     * @uses DeliveryType::setAlternativeDeliveryLocation()
     * @uses DeliveryType::setEstimatedDeliveryPeriod()
     * @uses DeliveryType::setCarrierParty()
     * @uses DeliveryType::setDeliveryParty()
     * @uses DeliveryType::setDespatch()
     * @uses DeliveryType::setDeliveryTerms()
     * @uses DeliveryType::setShipment()
     */
    public function __construct(IDType $iD = null, QuantityType $quantity = null, ActualDeliveryDateType $actualDeliveryDate = null, ActualDeliveryTimeType $actualDeliveryTime = null, LatestDeliveryDateType $latestDeliveryDate = null, LatestDeliveryTimeType $latestDeliveryTime = null, TrackingIDType $trackingID = null, AddressType $deliveryAddress = null, LocationType $alternativeDeliveryLocation = null, PeriodType $estimatedDeliveryPeriod = null, PartyType $carrierParty = null, PartyType $deliveryParty = null, DespatchType $despatch = null, array $deliveryTerms = array(), ShipmentType $shipment = null)
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualDeliveryTime($actualDeliveryTime)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setLatestDeliveryTime($latestDeliveryTime)
            ->setTrackingID($trackingID)
            ->setDeliveryAddress($deliveryAddress)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setCarrierParty($carrierParty)
            ->setDeliveryParty($deliveryParty)
            ->setDespatch($despatch)
            ->setDeliveryTerms($deliveryTerms)
            ->setShipment($shipment);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return DeliveryType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Quantity value
     * @return QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }

    /**
     * Set Quantity value
     * @param QuantityType $quantity
     * @return DeliveryType
     */
    public function setQuantity(QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }

    /**
     * Get ActualDeliveryDate value
     * @return ActualDeliveryDateType|null
     */
    public function getActualDeliveryDate()
    {
        return $this->ActualDeliveryDate;
    }

    /**
     * Set ActualDeliveryDate value
     * @param ActualDeliveryDateType $actualDeliveryDate
     * @return DeliveryType
     */
    public function setActualDeliveryDate(ActualDeliveryDateType $actualDeliveryDate = null)
    {
        $this->ActualDeliveryDate = $actualDeliveryDate;
        return $this;
    }

    /**
     * Get ActualDeliveryTime value
     * @return ActualDeliveryTimeType|null
     */
    public function getActualDeliveryTime()
    {
        return $this->ActualDeliveryTime;
    }

    /**
     * Set ActualDeliveryTime value
     * @param ActualDeliveryTimeType $actualDeliveryTime
     * @return DeliveryType
     */
    public function setActualDeliveryTime(ActualDeliveryTimeType $actualDeliveryTime = null)
    {
        $this->ActualDeliveryTime = $actualDeliveryTime;
        return $this;
    }

    /**
     * Get LatestDeliveryDate value
     * @return LatestDeliveryDateType|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->LatestDeliveryDate;
    }

    /**
     * Set LatestDeliveryDate value
     * @param LatestDeliveryDateType $latestDeliveryDate
     * @return DeliveryType
     */
    public function setLatestDeliveryDate(LatestDeliveryDateType $latestDeliveryDate = null)
    {
        $this->LatestDeliveryDate = $latestDeliveryDate;
        return $this;
    }

    /**
     * Get LatestDeliveryTime value
     * @return LatestDeliveryTimeType|null
     */
    public function getLatestDeliveryTime()
    {
        return $this->LatestDeliveryTime;
    }

    /**
     * Set LatestDeliveryTime value
     * @param LatestDeliveryTimeType $latestDeliveryTime
     * @return DeliveryType
     */
    public function setLatestDeliveryTime(LatestDeliveryTimeType $latestDeliveryTime = null)
    {
        $this->LatestDeliveryTime = $latestDeliveryTime;
        return $this;
    }

    /**
     * Get TrackingID value
     * @return TrackingIDType|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }

    /**
     * Set TrackingID value
     * @param TrackingIDType $trackingID
     * @return DeliveryType
     */
    public function setTrackingID(TrackingIDType $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }

    /**
     * Get DeliveryAddress value
     * @return AddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }

    /**
     * Set DeliveryAddress value
     * @param AddressType $deliveryAddress
     * @return DeliveryType
     */
    public function setDeliveryAddress(AddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }

    /**
     * Get AlternativeDeliveryLocation value
     * @return LocationType|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return $this->AlternativeDeliveryLocation;
    }

    /**
     * Set AlternativeDeliveryLocation value
     * @param LocationType $alternativeDeliveryLocation
     * @return DeliveryType
     */
    public function setAlternativeDeliveryLocation(LocationType $alternativeDeliveryLocation = null)
    {
        $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        return $this;
    }

    /**
     * Get EstimatedDeliveryPeriod value
     * @return PeriodType|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return $this->EstimatedDeliveryPeriod;
    }

    /**
     * Set EstimatedDeliveryPeriod value
     * @param PeriodType $estimatedDeliveryPeriod
     * @return DeliveryType
     */
    public function setEstimatedDeliveryPeriod(PeriodType $estimatedDeliveryPeriod = null)
    {
        $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        return $this;
    }

    /**
     * Get CarrierParty value
     * @return PartyType|null
     */
    public function getCarrierParty()
    {
        return $this->CarrierParty;
    }

    /**
     * Set CarrierParty value
     * @param PartyType $carrierParty
     * @return DeliveryType
     */
    public function setCarrierParty(PartyType $carrierParty = null)
    {
        $this->CarrierParty = $carrierParty;
        return $this;
    }

    /**
     * Get DeliveryParty value
     * @return PartyType|null
     */
    public function getDeliveryParty()
    {
        return $this->DeliveryParty;
    }

    /**
     * Set DeliveryParty value
     * @param PartyType $deliveryParty
     * @return DeliveryType
     */
    public function setDeliveryParty(PartyType $deliveryParty = null)
    {
        $this->DeliveryParty = $deliveryParty;
        return $this;
    }

    /**
     * Get Despatch value
     * @return DespatchType|null
     */
    public function getDespatch()
    {
        return $this->Despatch;
    }

    /**
     * Set Despatch value
     * @param DespatchType $despatch
     * @return DeliveryType
     */
    public function setDespatch(DespatchType $despatch = null)
    {
        $this->Despatch = $despatch;
        return $this;
    }

    /**
     * Get DeliveryTerms value
     * @return DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }

    /**
     * This method is responsible for validating the values passed to the setDeliveryTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryTypeDeliveryTermsItem) {
            // validation for constraint: itemType
            if (!$deliveryTypeDeliveryTermsItem instanceof DeliveryTermsType) {
                $invalidValues[] = is_object($deliveryTypeDeliveryTermsItem) ? get_class($deliveryTypeDeliveryTermsItem) : sprintf('%s(%s)', gettype($deliveryTypeDeliveryTermsItem), var_export($deliveryTypeDeliveryTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryTerms property can only contain items of type \Gek\UyumBahceGet\StructType\DeliveryTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DeliveryTerms value
     * @param DeliveryTermsType[] $deliveryTerms
     * @return DeliveryType
     * @throws InvalidArgumentException
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryTermsArrayErrorMessage = self::validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms($deliveryTerms))) {
            throw new InvalidArgumentException($deliveryTermsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }

    /**
     * Add item to DeliveryTerms value
     * @param DeliveryTermsType $item
     * @return DeliveryType
     * @throws InvalidArgumentException
     */
    public function addToDeliveryTerms(DeliveryTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DeliveryTermsType) {
            throw new InvalidArgumentException(sprintf('The DeliveryTerms property can only contain items of type \Gek\UyumBahceGet\StructType\DeliveryTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryTerms[] = $item;
        return $this;
    }

    /**
     * Get Shipment value
     * @return ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }

    /**
     * Set Shipment value
     * @param ShipmentType $shipment
     * @return DeliveryType
     */
    public function setShipment(ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
}
