<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for DateResponse StructType
 * @subpackage Structs
 */
class DateResponse extends Response
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Value;

    /**
     * Constructor method for DateResponse
     * @param string $value
     * @uses DateResponse::setValue()
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }

    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param string $value
     * @return DateResponse
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
