<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSummaryUsageReport StructType
 * @subpackage Structs
 */
class CustomerSummaryUsageReport extends AbstractStructBase
{
    /**
     * The Last10Days
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Last10DaysReport
     */
    public $Last10Days;
    /**
     * The MonthlyReports
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var MonthlyReportItem[]
     */
    public $MonthlyReports;

    /**
     * Constructor method for CustomerSummaryUsageReport
     * @param Last10DaysReport $last10Days
     * @param MonthlyReportItem[] $monthlyReports
     * @uses CustomerSummaryUsageReport::setLast10Days()
     * @uses CustomerSummaryUsageReport::setMonthlyReports()
     */
    public function __construct(Last10DaysReport $last10Days = null, array $monthlyReports = array())
    {
        $this
            ->setLast10Days($last10Days)
            ->setMonthlyReports($monthlyReports);
    }

    /**
     * Get Last10Days value
     * @return Last10DaysReport|null
     */
    public function getLast10Days()
    {
        return $this->Last10Days;
    }

    /**
     * Set Last10Days value
     * @param Last10DaysReport $last10Days
     * @return CustomerSummaryUsageReport
     */
    public function setLast10Days(Last10DaysReport $last10Days = null)
    {
        $this->Last10Days = $last10Days;
        return $this;
    }

    /**
     * Get MonthlyReports value
     * @return MonthlyReportItem[]|null
     */
    public function getMonthlyReports()
    {
        return $this->MonthlyReports;
    }

    /**
     * This method is responsible for validating the values passed to the setMonthlyReports method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMonthlyReports method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMonthlyReportsForArrayConstraintsFromSetMonthlyReports(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSummaryUsageReportMonthlyReportsItem) {
            // validation for constraint: itemType
            if (!$customerSummaryUsageReportMonthlyReportsItem instanceof MonthlyReportItem) {
                $invalidValues[] = is_object($customerSummaryUsageReportMonthlyReportsItem) ? get_class($customerSummaryUsageReportMonthlyReportsItem) : sprintf('%s(%s)', gettype($customerSummaryUsageReportMonthlyReportsItem), var_export($customerSummaryUsageReportMonthlyReportsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MonthlyReports property can only contain items of type \Gek\UyumBahceGet\StructType\MonthlyReportItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set MonthlyReports value
     * @param MonthlyReportItem[] $monthlyReports
     * @return CustomerSummaryUsageReport
     * @throws InvalidArgumentException
     */
    public function setMonthlyReports(array $monthlyReports = array())
    {
        // validation for constraint: array
        if ('' !== ($monthlyReportsArrayErrorMessage = self::validateMonthlyReportsForArrayConstraintsFromSetMonthlyReports($monthlyReports))) {
            throw new InvalidArgumentException($monthlyReportsArrayErrorMessage, __LINE__);
        }
        $this->MonthlyReports = $monthlyReports;
        return $this;
    }

    /**
     * Add item to MonthlyReports value
     * @param MonthlyReportItem $item
     * @return CustomerSummaryUsageReport
     * @throws InvalidArgumentException
     */
    public function addToMonthlyReports(MonthlyReportItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof MonthlyReportItem) {
            throw new InvalidArgumentException(sprintf('The MonthlyReports property can only contain items of type \Gek\UyumBahceGet\StructType\MonthlyReportItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MonthlyReports[] = $item;
        return $this;
    }
}
