<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateRegistrationSchemeType StructType
 * @subpackage Structs
 */
class CorporateRegistrationSchemeType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var NameType
     */
    public $Name;
    /**
     * The CorporateRegistrationTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CorporateRegistrationTypeCode
     * @var CorporateRegistrationTypeCodeType
     */
    public $CorporateRegistrationTypeCode;
    /**
     * The JurisdictionRegionAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AddressType[]
     */
    public $JurisdictionRegionAddress;

    /**
     * Constructor method for CorporateRegistrationSchemeType
     * @param IDType $iD
     * @param NameType $name
     * @param CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode
     * @param AddressType[] $jurisdictionRegionAddress
     * @uses CorporateRegistrationSchemeType::setID()
     * @uses CorporateRegistrationSchemeType::setName()
     * @uses CorporateRegistrationSchemeType::setCorporateRegistrationTypeCode()
     * @uses CorporateRegistrationSchemeType::setJurisdictionRegionAddress()
     */
    public function __construct(IDType $iD = null, NameType $name = null, CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode = null, array $jurisdictionRegionAddress = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setCorporateRegistrationTypeCode($corporateRegistrationTypeCode)
            ->setJurisdictionRegionAddress($jurisdictionRegionAddress);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return CorporateRegistrationSchemeType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Name value
     * @return NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * Set Name value
     * @param NameType $name
     * @return CorporateRegistrationSchemeType
     */
    public function setName(NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }

    /**
     * Get CorporateRegistrationTypeCode value
     * @return CorporateRegistrationTypeCodeType|null
     */
    public function getCorporateRegistrationTypeCode()
    {
        return $this->CorporateRegistrationTypeCode;
    }

    /**
     * Set CorporateRegistrationTypeCode value
     * @param CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode
     * @return CorporateRegistrationSchemeType
     */
    public function setCorporateRegistrationTypeCode(CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode = null)
    {
        $this->CorporateRegistrationTypeCode = $corporateRegistrationTypeCode;
        return $this;
    }

    /**
     * Get JurisdictionRegionAddress value
     * @return AddressType[]|null
     */
    public function getJurisdictionRegionAddress()
    {
        return $this->JurisdictionRegionAddress;
    }

    /**
     * This method is responsible for validating the values passed to the setJurisdictionRegionAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJurisdictionRegionAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJurisdictionRegionAddressForArrayConstraintsFromSetJurisdictionRegionAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporateRegistrationSchemeTypeJurisdictionRegionAddressItem) {
            // validation for constraint: itemType
            if (!$corporateRegistrationSchemeTypeJurisdictionRegionAddressItem instanceof AddressType) {
                $invalidValues[] = is_object($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem) ? get_class($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem) : sprintf('%s(%s)', gettype($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem), var_export($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JurisdictionRegionAddress property can only contain items of type \Gek\UyumBahceGet\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set JurisdictionRegionAddress value
     * @param AddressType[] $jurisdictionRegionAddress
     * @return CorporateRegistrationSchemeType
     * @throws InvalidArgumentException
     */
    public function setJurisdictionRegionAddress(array $jurisdictionRegionAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($jurisdictionRegionAddressArrayErrorMessage = self::validateJurisdictionRegionAddressForArrayConstraintsFromSetJurisdictionRegionAddress($jurisdictionRegionAddress))) {
            throw new InvalidArgumentException($jurisdictionRegionAddressArrayErrorMessage, __LINE__);
        }
        $this->JurisdictionRegionAddress = $jurisdictionRegionAddress;
        return $this;
    }

    /**
     * Add item to JurisdictionRegionAddress value
     * @param AddressType $item
     * @return CorporateRegistrationSchemeType
     * @throws InvalidArgumentException
     */
    public function addToJurisdictionRegionAddress(AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AddressType) {
            throw new InvalidArgumentException(sprintf('The JurisdictionRegionAddress property can only contain items of type \Gek\UyumBahceGet\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JurisdictionRegionAddress[] = $item;
        return $this;
    }
}
