<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for CloneInvoiceServiceResponse StructType
 * @subpackage Structs
 */
class CloneInvoiceServiceResponse extends Response
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ClonedInvoiceInfo[]
     */
    public $Value;

    /**
     * Constructor method for CloneInvoiceServiceResponse
     * @param ClonedInvoiceInfo[] $value
     * @uses CloneInvoiceServiceResponse::setValue()
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }

    /**
     * Get Value value
     * @return ClonedInvoiceInfo[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cloneInvoiceServiceResponseValueItem) {
            // validation for constraint: itemType
            if (!$cloneInvoiceServiceResponseValueItem instanceof ClonedInvoiceInfo) {
                $invalidValues[] = is_object($cloneInvoiceServiceResponseValueItem) ? get_class($cloneInvoiceServiceResponseValueItem) : sprintf('%s(%s)', gettype($cloneInvoiceServiceResponseValueItem), var_export($cloneInvoiceServiceResponseValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \Gek\UyumBahceGet\StructType\ClonedInvoiceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Value value
     * @param ClonedInvoiceInfo[] $value
     * @return CloneInvoiceServiceResponse
     * @throws InvalidArgumentException
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }

    /**
     * Add item to Value value
     * @param ClonedInvoiceInfo $item
     * @return CloneInvoiceServiceResponse
     * @throws InvalidArgumentException
     */
    public function addToValue(ClonedInvoiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ClonedInvoiceInfo) {
            throw new InvalidArgumentException(sprintf('The Value property can only contain items of type \Gek\UyumBahceGet\StructType\ClonedInvoiceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
