<?php /** @noinspection PhpMissingParentConstructorInspection */


namespace Gek\UyumBahceGet\StructType;

use DOMDocument;
use InvalidArgumentException;

/**
 * This class stands for CanonicalizationMethodType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class CanonicalizationMethodType extends TextType
{
    /**
     * The any
     * @var DOMDocument
     */
    public $any;
    /**
     * The Algorithm
     * @var string
     */
    public $Algorithm;

    /**
     * Constructor method for CanonicalizationMethodType
     * @param DOMDocument $any
     * @param string $algorithm
     * @uses CanonicalizationMethodType::setAny()
     * @uses CanonicalizationMethodType::setAlgorithm()
     */
    public function __construct(DOMDocument $any = null, $algorithm = null)
    {
        $this
            ->setAny($any)
            ->setAlgorithm($algorithm);
    }

    /**
     * Get any value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }

    /**
     * Set any value
     * @param DOMDocument $any
     * @return CanonicalizationMethodType
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setAny(DOMDocument $any = null)
    {
        $this->any = ($any instanceof DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }

    /**
     * Get Algorithm value
     * @return string|null
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }

    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return CanonicalizationMethodType
     */
    public function setAlgorithm($algorithm = null)
    {
        // validation for constraint: string
        if (!is_null($algorithm) && !is_string($algorithm)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($algorithm, true), gettype($algorithm)), __LINE__);
        }
        $this->Algorithm = $algorithm;
        return $this;
    }
}
