<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BinaryObjectType StructType
 * @subpackage Structs
 */
class BinaryObjectType extends AbstractStructBase
{
    /**
     * The _
     * @var BinaryObjectType
     */
    public $_;
    /**
     * The format
     * @var string
     */
    public $format;
    /**
     * The mimeCode
     * @var string
     */
    public $mimeCode;
    /**
     * The encodingCode
     * @var string
     */
    public $encodingCode;
    /**
     * The characterSetCode
     * @var string
     */
    public $characterSetCode;
    /**
     * The uri
     * @var string
     */
    public $uri;
    /**
     * The filename
     * @var string
     */
    public $filename;

    /**
     * Constructor method for BinaryObjectType
     * @param BinaryObjectType $_
     * @param string $format
     * @param string $mimeCode
     * @param string $encodingCode
     * @param string $characterSetCode
     * @param string $uri
     * @param string $filename
     * @uses BinaryObjectType::set_()
     * @uses BinaryObjectType::setFormat()
     * @uses BinaryObjectType::setMimeCode()
     * @uses BinaryObjectType::setEncodingCode()
     * @uses BinaryObjectType::setCharacterSetCode()
     * @uses BinaryObjectType::setUri()
     * @uses BinaryObjectType::setFilename()
     */
    public function __construct(BinaryObjectType $_ = null, $format = null, $mimeCode = null, $encodingCode = null, $characterSetCode = null, $uri = null, $filename = null)
    {
        $this
            ->set_($_)
            ->setFormat($format)
            ->setMimeCode($mimeCode)
            ->setEncodingCode($encodingCode)
            ->setCharacterSetCode($characterSetCode)
            ->setUri($uri)
            ->setFilename($filename);
    }

    /**
     * Get _ value
     * @return BinaryObjectType|null
     */
    public function get_()
    {
        return $this->_;
    }

    /**
     * Set _ value
     * @param BinaryObjectType $_
     * @return BinaryObjectType
     */
    public function set_(BinaryObjectType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }

    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }

    /**
     * Set format value
     * @param string $format
     * @return BinaryObjectType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }

    /**
     * Get mimeCode value
     * @return string|null
     */
    public function getMimeCode()
    {
        return $this->mimeCode;
    }

    /**
     * Set mimeCode value
     * @param string $mimeCode
     * @return BinaryObjectType
     */
    public function setMimeCode($mimeCode = null)
    {
        // validation for constraint: string
        if (!is_null($mimeCode) && !is_string($mimeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeCode, true), gettype($mimeCode)), __LINE__);
        }
        $this->mimeCode = $mimeCode;
        return $this;
    }

    /**
     * Get encodingCode value
     * @return string|null
     */
    public function getEncodingCode()
    {
        return $this->encodingCode;
    }

    /**
     * Set encodingCode value
     * @param string $encodingCode
     * @return BinaryObjectType
     */
    public function setEncodingCode($encodingCode = null)
    {
        // validation for constraint: string
        if (!is_null($encodingCode) && !is_string($encodingCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encodingCode, true), gettype($encodingCode)), __LINE__);
        }
        $this->encodingCode = $encodingCode;
        return $this;
    }

    /**
     * Get characterSetCode value
     * @return string|null
     */
    public function getCharacterSetCode()
    {
        return $this->characterSetCode;
    }

    /**
     * Set characterSetCode value
     * @param string $characterSetCode
     * @return BinaryObjectType
     */
    public function setCharacterSetCode($characterSetCode = null)
    {
        // validation for constraint: string
        if (!is_null($characterSetCode) && !is_string($characterSetCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characterSetCode, true), gettype($characterSetCode)), __LINE__);
        }
        $this->characterSetCode = $characterSetCode;
        return $this;
    }

    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Set uri value
     * @param string $uri
     * @return BinaryObjectType
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }

    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * Set filename value
     * @param string $filename
     * @return BinaryObjectType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
}
