<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReferenceType StructType
 * @subpackage Structs
 */
class BillingReferenceType extends AbstractStructBase
{
    /**
     * The InvoiceDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $InvoiceDocumentReference;
    /**
     * The SelfBilledInvoiceDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $SelfBilledInvoiceDocumentReference;
    /**
     * The CreditNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $CreditNoteDocumentReference;
    /**
     * The SelfBilledCreditNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $SelfBilledCreditNoteDocumentReference;
    /**
     * The DebitNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $DebitNoteDocumentReference;
    /**
     * The ReminderDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $ReminderDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $AdditionalDocumentReference;
    /**
     * The BillingReferenceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var BillingReferenceLineType[]
     */
    public $BillingReferenceLine;

    /**
     * Constructor method for BillingReferenceType
     * @param DocumentReferenceType $invoiceDocumentReference
     * @param DocumentReferenceType $selfBilledInvoiceDocumentReference
     * @param DocumentReferenceType $creditNoteDocumentReference
     * @param DocumentReferenceType $selfBilledCreditNoteDocumentReference
     * @param DocumentReferenceType $debitNoteDocumentReference
     * @param DocumentReferenceType $reminderDocumentReference
     * @param DocumentReferenceType $additionalDocumentReference
     * @param BillingReferenceLineType[] $billingReferenceLine
     * @uses BillingReferenceType::setInvoiceDocumentReference()
     * @uses BillingReferenceType::setSelfBilledInvoiceDocumentReference()
     * @uses BillingReferenceType::setCreditNoteDocumentReference()
     * @uses BillingReferenceType::setSelfBilledCreditNoteDocumentReference()
     * @uses BillingReferenceType::setDebitNoteDocumentReference()
     * @uses BillingReferenceType::setReminderDocumentReference()
     * @uses BillingReferenceType::setAdditionalDocumentReference()
     * @uses BillingReferenceType::setBillingReferenceLine()
     */
    public function __construct(DocumentReferenceType $invoiceDocumentReference = null, DocumentReferenceType $selfBilledInvoiceDocumentReference = null, DocumentReferenceType $creditNoteDocumentReference = null, DocumentReferenceType $selfBilledCreditNoteDocumentReference = null, DocumentReferenceType $debitNoteDocumentReference = null, DocumentReferenceType $reminderDocumentReference = null, DocumentReferenceType $additionalDocumentReference = null, array $billingReferenceLine = array())
    {
        $this
            ->setInvoiceDocumentReference($invoiceDocumentReference)
            ->setSelfBilledInvoiceDocumentReference($selfBilledInvoiceDocumentReference)
            ->setCreditNoteDocumentReference($creditNoteDocumentReference)
            ->setSelfBilledCreditNoteDocumentReference($selfBilledCreditNoteDocumentReference)
            ->setDebitNoteDocumentReference($debitNoteDocumentReference)
            ->setReminderDocumentReference($reminderDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setBillingReferenceLine($billingReferenceLine);
    }

    /**
     * Get InvoiceDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getInvoiceDocumentReference()
    {
        return $this->InvoiceDocumentReference;
    }

    /**
     * Set InvoiceDocumentReference value
     * @param DocumentReferenceType $invoiceDocumentReference
     * @return BillingReferenceType
     */
    public function setInvoiceDocumentReference(DocumentReferenceType $invoiceDocumentReference = null)
    {
        $this->InvoiceDocumentReference = $invoiceDocumentReference;
        return $this;
    }

    /**
     * Get SelfBilledInvoiceDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getSelfBilledInvoiceDocumentReference()
    {
        return $this->SelfBilledInvoiceDocumentReference;
    }

    /**
     * Set SelfBilledInvoiceDocumentReference value
     * @param DocumentReferenceType $selfBilledInvoiceDocumentReference
     * @return BillingReferenceType
     */
    public function setSelfBilledInvoiceDocumentReference(DocumentReferenceType $selfBilledInvoiceDocumentReference = null)
    {
        $this->SelfBilledInvoiceDocumentReference = $selfBilledInvoiceDocumentReference;
        return $this;
    }

    /**
     * Get CreditNoteDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getCreditNoteDocumentReference()
    {
        return $this->CreditNoteDocumentReference;
    }

    /**
     * Set CreditNoteDocumentReference value
     * @param DocumentReferenceType $creditNoteDocumentReference
     * @return BillingReferenceType
     */
    public function setCreditNoteDocumentReference(DocumentReferenceType $creditNoteDocumentReference = null)
    {
        $this->CreditNoteDocumentReference = $creditNoteDocumentReference;
        return $this;
    }

    /**
     * Get SelfBilledCreditNoteDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getSelfBilledCreditNoteDocumentReference()
    {
        return $this->SelfBilledCreditNoteDocumentReference;
    }

    /**
     * Set SelfBilledCreditNoteDocumentReference value
     * @param DocumentReferenceType $selfBilledCreditNoteDocumentReference
     * @return BillingReferenceType
     */
    public function setSelfBilledCreditNoteDocumentReference(DocumentReferenceType $selfBilledCreditNoteDocumentReference = null)
    {
        $this->SelfBilledCreditNoteDocumentReference = $selfBilledCreditNoteDocumentReference;
        return $this;
    }

    /**
     * Get DebitNoteDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getDebitNoteDocumentReference()
    {
        return $this->DebitNoteDocumentReference;
    }

    /**
     * Set DebitNoteDocumentReference value
     * @param DocumentReferenceType $debitNoteDocumentReference
     * @return BillingReferenceType
     */
    public function setDebitNoteDocumentReference(DocumentReferenceType $debitNoteDocumentReference = null)
    {
        $this->DebitNoteDocumentReference = $debitNoteDocumentReference;
        return $this;
    }

    /**
     * Get ReminderDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getReminderDocumentReference()
    {
        return $this->ReminderDocumentReference;
    }

    /**
     * Set ReminderDocumentReference value
     * @param DocumentReferenceType $reminderDocumentReference
     * @return BillingReferenceType
     */
    public function setReminderDocumentReference(DocumentReferenceType $reminderDocumentReference = null)
    {
        $this->ReminderDocumentReference = $reminderDocumentReference;
        return $this;
    }

    /**
     * Get AdditionalDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }

    /**
     * Set AdditionalDocumentReference value
     * @param DocumentReferenceType $additionalDocumentReference
     * @return BillingReferenceType
     */
    public function setAdditionalDocumentReference(DocumentReferenceType $additionalDocumentReference = null)
    {
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }

    /**
     * Get BillingReferenceLine value
     * @return BillingReferenceLineType[]|null
     */
    public function getBillingReferenceLine()
    {
        return $this->BillingReferenceLine;
    }

    /**
     * This method is responsible for validating the values passed to the setBillingReferenceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingReferenceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingReferenceLineForArrayConstraintsFromSetBillingReferenceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingReferenceTypeBillingReferenceLineItem) {
            // validation for constraint: itemType
            if (!$billingReferenceTypeBillingReferenceLineItem instanceof BillingReferenceLineType) {
                $invalidValues[] = is_object($billingReferenceTypeBillingReferenceLineItem) ? get_class($billingReferenceTypeBillingReferenceLineItem) : sprintf('%s(%s)', gettype($billingReferenceTypeBillingReferenceLineItem), var_export($billingReferenceTypeBillingReferenceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingReferenceLine property can only contain items of type \Gek\UyumBahceGet\StructType\BillingReferenceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set BillingReferenceLine value
     * @param BillingReferenceLineType[] $billingReferenceLine
     * @return BillingReferenceType
     * @throws InvalidArgumentException
     */
    public function setBillingReferenceLine(array $billingReferenceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($billingReferenceLineArrayErrorMessage = self::validateBillingReferenceLineForArrayConstraintsFromSetBillingReferenceLine($billingReferenceLine))) {
            throw new InvalidArgumentException($billingReferenceLineArrayErrorMessage, __LINE__);
        }
        $this->BillingReferenceLine = $billingReferenceLine;
        return $this;
    }

    /**
     * Add item to BillingReferenceLine value
     * @param BillingReferenceLineType $item
     * @return BillingReferenceType
     * @throws InvalidArgumentException
     */
    public function addToBillingReferenceLine(BillingReferenceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof BillingReferenceLineType) {
            throw new InvalidArgumentException(sprintf('The BillingReferenceLine property can only contain items of type \Gek\UyumBahceGet\StructType\BillingReferenceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingReferenceLine[] = $item;
        return $this;
    }
}
