<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReferenceLineType StructType
 * @subpackage Structs
 */
class BillingReferenceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Amount
     * @var AmountType
     */
    public $Amount;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AllowanceChargeType[]
     */
    public $AllowanceCharge;

    /**
     * Constructor method for BillingReferenceLineType
     * @param IDType $iD
     * @param AmountType $amount
     * @param AllowanceChargeType[] $allowanceCharge
     * @uses BillingReferenceLineType::setID()
     * @uses BillingReferenceLineType::setAmount()
     * @uses BillingReferenceLineType::setAllowanceCharge()
     */
    public function __construct(IDType $iD = null, AmountType $amount = null, array $allowanceCharge = array())
    {
        $this
            ->setID($iD)
            ->setAmount($amount)
            ->setAllowanceCharge($allowanceCharge);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return BillingReferenceLineType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Amount value
     * @return AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }

    /**
     * Set Amount value
     * @param AmountType $amount
     * @return BillingReferenceLineType
     */
    public function setAmount(AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }

    /**
     * Get AllowanceCharge value
     * @return AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }

    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingReferenceLineTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$billingReferenceLineTypeAllowanceChargeItem instanceof AllowanceChargeType) {
                $invalidValues[] = is_object($billingReferenceLineTypeAllowanceChargeItem) ? get_class($billingReferenceLineTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($billingReferenceLineTypeAllowanceChargeItem), var_export($billingReferenceLineTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahceGet\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set AllowanceCharge value
     * @param AllowanceChargeType[] $allowanceCharge
     * @return BillingReferenceLineType
     * @throws InvalidArgumentException
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }

    /**
     * Add item to AllowanceCharge value
     * @param AllowanceChargeType $item
     * @return BillingReferenceLineType
     * @throws InvalidArgumentException
     */
    public function addToAllowanceCharge(AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AllowanceChargeType) {
            throw new InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahceGet\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
}
