<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseClass StructType
 * @subpackage Structs
 */
class BaseClass extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The IsPassive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IsPassive;
    /**
     * The SourceApp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceApp;
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CoId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WhouseId;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;

    /**
     * Constructor method for BaseClass
     * @param int $id
     * @param int $isPassive
     * @param int $sourceApp
     * @param int $coId
     * @param int $branchId
     * @param int $whouseId
     * @param string $code
     * @param string $description
     * @uses BaseClass::setId()
     * @uses BaseClass::setIsPassive()
     * @uses BaseClass::setSourceApp()
     * @uses BaseClass::setCoId()
     * @uses BaseClass::setBranchId()
     * @uses BaseClass::setWhouseId()
     * @uses BaseClass::setCode()
     * @uses BaseClass::setDescription()
     */
    public function __construct($id = null, $isPassive = null, $sourceApp = null, $coId = null, $branchId = null, $whouseId = null, $code = null, $description = null)
    {
        $this
            ->setId($id)
            ->setIsPassive($isPassive)
            ->setSourceApp($sourceApp)
            ->setCoId($coId)
            ->setBranchId($branchId)
            ->setWhouseId($whouseId)
            ->setCode($code)
            ->setDescription($description);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return BaseClass
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get IsPassive value
     * @return int
     */
    public function getIsPassive()
    {
        return $this->IsPassive;
    }

    /**
     * Set IsPassive value
     * @param int $isPassive
     * @return BaseClass
     */
    public function setIsPassive($isPassive = null)
    {
        // validation for constraint: int
        if (!is_null($isPassive) && !(is_int($isPassive) || ctype_digit($isPassive))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isPassive, true), gettype($isPassive)), __LINE__);
        }
        $this->IsPassive = $isPassive;
        return $this;
    }

    /**
     * Get SourceApp value
     * @return int
     */
    public function getSourceApp()
    {
        return $this->SourceApp;
    }

    /**
     * Set SourceApp value
     * @param int $sourceApp
     * @return BaseClass
     */
    public function setSourceApp($sourceApp = null)
    {
        // validation for constraint: int
        if (!is_null($sourceApp) && !(is_int($sourceApp) || ctype_digit($sourceApp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceApp, true), gettype($sourceApp)), __LINE__);
        }
        $this->SourceApp = $sourceApp;
        return $this;
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return BaseClass
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return BaseClass
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }

    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }

    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return BaseClass
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }

    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * Set Code value
     * @param string $code
     * @return BaseClass
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }

    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Set Description value
     * @param string $description
     * @return BaseClass
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
