<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllowanceChargeType StructType
 * @subpackage Structs
 */
class AllowanceChargeType extends AbstractStructBase
{
    /**
     * The ChargeIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeIndicator
     * @var ChargeIndicatorType
     */
    public $ChargeIndicator;
    /**
     * The AllowanceChargeReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AllowanceChargeReason
     * @var AllowanceChargeReasonType
     */
    public $AllowanceChargeReason;
    /**
     * The MultiplierFactorNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:MultiplierFactorNumeric
     * @var MultiplierFactorNumericType
     */
    public $MultiplierFactorNumeric;
    /**
     * The SequenceNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SequenceNumeric
     * @var SequenceNumericType
     */
    public $SequenceNumeric;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Amount
     * @var AmountType
     */
    public $Amount;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:BaseAmount
     * @var BaseAmountType
     */
    public $BaseAmount;
    /**
     * The PerUnitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PerUnitAmount
     * @var PerUnitAmountType
     */
    public $PerUnitAmount;

    /**
     * Constructor method for AllowanceChargeType
     * @param ChargeIndicatorType $chargeIndicator
     * @param AllowanceChargeReasonType $allowanceChargeReason
     * @param MultiplierFactorNumericType $multiplierFactorNumeric
     * @param SequenceNumericType $sequenceNumeric
     * @param AmountType $amount
     * @param BaseAmountType $baseAmount
     * @param PerUnitAmountType $perUnitAmount
     * @uses AllowanceChargeType::setChargeIndicator()
     * @uses AllowanceChargeType::setAllowanceChargeReason()
     * @uses AllowanceChargeType::setMultiplierFactorNumeric()
     * @uses AllowanceChargeType::setSequenceNumeric()
     * @uses AllowanceChargeType::setAmount()
     * @uses AllowanceChargeType::setBaseAmount()
     * @uses AllowanceChargeType::setPerUnitAmount()
     */
    public function __construct(ChargeIndicatorType $chargeIndicator = null, AllowanceChargeReasonType $allowanceChargeReason = null, MultiplierFactorNumericType $multiplierFactorNumeric = null, SequenceNumericType $sequenceNumeric = null, AmountType $amount = null, BaseAmountType $baseAmount = null, PerUnitAmountType $perUnitAmount = null)
    {
        $this
            ->setChargeIndicator($chargeIndicator)
            ->setAllowanceChargeReason($allowanceChargeReason)
            ->setMultiplierFactorNumeric($multiplierFactorNumeric)
            ->setSequenceNumeric($sequenceNumeric)
            ->setAmount($amount)
            ->setBaseAmount($baseAmount)
            ->setPerUnitAmount($perUnitAmount);
    }

    /**
     * Get ChargeIndicator value
     * @return ChargeIndicatorType|null
     */
    public function getChargeIndicator()
    {
        return $this->ChargeIndicator;
    }

    /**
     * Set ChargeIndicator value
     * @param ChargeIndicatorType $chargeIndicator
     * @return AllowanceChargeType
     */
    public function setChargeIndicator(ChargeIndicatorType $chargeIndicator = null)
    {
        $this->ChargeIndicator = $chargeIndicator;
        return $this;
    }

    /**
     * Get AllowanceChargeReason value
     * @return AllowanceChargeReasonType|null
     */
    public function getAllowanceChargeReason()
    {
        return $this->AllowanceChargeReason;
    }

    /**
     * Set AllowanceChargeReason value
     * @param AllowanceChargeReasonType $allowanceChargeReason
     * @return AllowanceChargeType
     */
    public function setAllowanceChargeReason(AllowanceChargeReasonType $allowanceChargeReason = null)
    {
        $this->AllowanceChargeReason = $allowanceChargeReason;
        return $this;
    }

    /**
     * Get MultiplierFactorNumeric value
     * @return MultiplierFactorNumericType|null
     */
    public function getMultiplierFactorNumeric()
    {
        return $this->MultiplierFactorNumeric;
    }

    /**
     * Set MultiplierFactorNumeric value
     * @param MultiplierFactorNumericType $multiplierFactorNumeric
     * @return AllowanceChargeType
     */
    public function setMultiplierFactorNumeric(MultiplierFactorNumericType $multiplierFactorNumeric = null)
    {
        $this->MultiplierFactorNumeric = $multiplierFactorNumeric;
        return $this;
    }

    /**
     * Get SequenceNumeric value
     * @return SequenceNumericType|null
     */
    public function getSequenceNumeric()
    {
        return $this->SequenceNumeric;
    }

    /**
     * Set SequenceNumeric value
     * @param SequenceNumericType $sequenceNumeric
     * @return AllowanceChargeType
     */
    public function setSequenceNumeric(SequenceNumericType $sequenceNumeric = null)
    {
        $this->SequenceNumeric = $sequenceNumeric;
        return $this;
    }

    /**
     * Get Amount value
     * @return AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }

    /**
     * Set Amount value
     * @param AmountType $amount
     * @return AllowanceChargeType
     */
    public function setAmount(AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }

    /**
     * Get BaseAmount value
     * @return BaseAmountType|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }

    /**
     * Set BaseAmount value
     * @param BaseAmountType $baseAmount
     * @return AllowanceChargeType
     */
    public function setBaseAmount(BaseAmountType $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }

    /**
     * Get PerUnitAmount value
     * @return PerUnitAmountType|null
     */
    public function getPerUnitAmount()
    {
        return $this->PerUnitAmount;
    }

    /**
     * Set PerUnitAmount value
     * @param PerUnitAmountType $perUnitAmount
     * @return AllowanceChargeType
     */
    public function setPerUnitAmount(PerUnitAmountType $perUnitAmount = null)
    {
        $this->PerUnitAmount = $perUnitAmount;
        return $this;
    }
}
