<?php /** @noinspection PhpRedundantCatchClauseInspection */


namespace Gek\UyumBahceGet\ServiceType;

use Gek\UyumBahceGet\StructType\GetAcc;
use Gek\UyumBahceGet\StructType\GetAccMM;
use Gek\UyumBahceGet\StructType\GetAccMMResponse;
use Gek\UyumBahceGet\StructType\GetAccResponse;
use Gek\UyumBahceGet\StructType\GetBankAcc;
use Gek\UyumBahceGet\StructType\GetBankAccResponse;
use Gek\UyumBahceGet\StructType\GetBankAccType;
use Gek\UyumBahceGet\StructType\GetBankAccTypeResponse;
use Gek\UyumBahceGet\StructType\GetBranchExpenseList;
use Gek\UyumBahceGet\StructType\GetBranchExpenseListResponse;
use Gek\UyumBahceGet\StructType\GetBranchItemList;
use Gek\UyumBahceGet\StructType\GetBranchItemListResponse;
use Gek\UyumBahceGet\StructType\GetBranchList;
use Gek\UyumBahceGet\StructType\GetBranchListResponse;
use Gek\UyumBahceGet\StructType\GetBwhItemDetail;
use Gek\UyumBahceGet\StructType\GetBwhItemDetailResponse;
use Gek\UyumBahceGet\StructType\GetCoEntity;
use Gek\UyumBahceGet\StructType\GetCoEntityResponse;
use Gek\UyumBahceGet\StructType\GetCompanyList;
use Gek\UyumBahceGet\StructType\GetCompanyListResponse;
use Gek\UyumBahceGet\StructType\GetDataTableWithPagingSQL;
use Gek\UyumBahceGet\StructType\GetDataTableWithPagingSQLResponse;
use Gek\UyumBahceGet\StructType\GetDataTableWithSQL;
use Gek\UyumBahceGet\StructType\GetDataTableWithSQLResponse;
use Gek\UyumBahceGet\StructType\GetEDespatchHTMLByETTN;
use Gek\UyumBahceGet\StructType\GetEDespatchHTMLByETTNResponse;
use Gek\UyumBahceGet\StructType\GetEInvoiceHTML;
use Gek\UyumBahceGet\StructType\GetEInvoiceHTMLResponse;
use Gek\UyumBahceGet\StructType\GetEInvoiceUser;
use Gek\UyumBahceGet\StructType\GetEInvoiceUserResponse;
use Gek\UyumBahceGet\StructType\GetEntity;
use Gek\UyumBahceGet\StructType\GetEntityCode;
use Gek\UyumBahceGet\StructType\GetEntityCodeResponse;
use Gek\UyumBahceGet\StructType\GetEntityExtraAction;
use Gek\UyumBahceGet\StructType\GetEntityExtraActionResponse;
use Gek\UyumBahceGet\StructType\GetEntityResponse;
use Gek\UyumBahceGet\StructType\GetExpense;
use Gek\UyumBahceGet\StructType\GetExpenseResponse;
use Gek\UyumBahceGet\StructType\GetFinance;
use Gek\UyumBahceGet\StructType\GetFinanceResponse;
use Gek\UyumBahceGet\StructType\GetFuncValues;
use Gek\UyumBahceGet\StructType\GetFuncValuesResponse;
use Gek\UyumBahceGet\StructType\GetInvoice;
use Gek\UyumBahceGet\StructType\GetInvoiceResponse;
use Gek\UyumBahceGet\StructType\GetItem;
use Gek\UyumBahceGet\StructType\GetItemImage;
use Gek\UyumBahceGet\StructType\GetItemImageResponse;
use Gek\UyumBahceGet\StructType\GetItemList;
use Gek\UyumBahceGet\StructType\GetItemListCount;
use Gek\UyumBahceGet\StructType\GetItemListCountResponse;
use Gek\UyumBahceGet\StructType\GetItemListResponse;
use Gek\UyumBahceGet\StructType\GetItemM;
use Gek\UyumBahceGet\StructType\GetItemMResponse;
use Gek\UyumBahceGet\StructType\GetItemResponse;
use Gek\UyumBahceGet\StructType\GetItemUnitPriceTra;
use Gek\UyumBahceGet\StructType\GetItemUnitPriceTraResponse;
use Gek\UyumBahceGet\StructType\GetObjectToDataSet;
use Gek\UyumBahceGet\StructType\GetObjectToDataSetResponse;
use Gek\UyumBahceGet\StructType\GetObjectWSDL;
use Gek\UyumBahceGet\StructType\GetObjectWSDLResponse;
use Gek\UyumBahceGet\StructType\GetOrderM;
use Gek\UyumBahceGet\StructType\GetOrderMResponse;
use Gek\UyumBahceGet\StructType\GetPrdBomM;
use Gek\UyumBahceGet\StructType\GetPrdBomMResponse;
use Gek\UyumBahceGet\StructType\GetPrdWorderM;
use Gek\UyumBahceGet\StructType\GetPrdWorderMResponse;
use Gek\UyumBahceGet\StructType\GetTableValues;
use Gek\UyumBahceGet\StructType\GetTableValuesResponse;
use Gek\UyumBahceGet\StructType\GetWaybill;
use Gek\UyumBahceGet\StructType\GetWaybillResponse;
use SoapFault;
use WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetOrderM
     * Meta information extracted from the WSDL
     * - documentation: Sipariş Kayıtlarını Detaylarıyla Listeler.
     * @param GetOrderM $parameters
     * @return GetOrderMResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetOrderM(GetOrderM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetOrderM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetInvoice
     * Meta information extracted from the WSDL
     * - documentation: Fatura Kayıtlarını Detaylarıyla Listeler.
     * @param GetInvoice $parameters
     * @return GetInvoiceResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetInvoice(GetInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetFinance
     * Meta information extracted from the WSDL
     * - documentation: Finans Kayıtlarını Detaylarıyla Listeler.
     * @param GetFinance $parameters
     * @return GetFinanceResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetFinance(GetFinance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetFinance', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetAcc $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetInvoiceResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetAcc(GetAcc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetAcc', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetAccMM
     * Meta information extracted from the WSDL
     * - documentation: Mali Müşavir Muhasebe Fiş Kayıtlarını Detaylarıyla Listeler.
     * @param GetAccMM $parameters
     * @return GetAccMMResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetAccMM(GetAccMM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetAccMM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetBankAccType
     * Meta information extracted from the WSDL
     * - documentation: Banka Hesap Tiplerini Listeler
     * @param GetBankAccType $parameters
     * @return GetBankAccTypeResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetBankAccType(GetBankAccType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetBankAccType', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetBankAcc $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetBankAcc(GetBankAcc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetBankAcc', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetEntity $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetEntity(GetEntity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetEntity', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetCoEntity
     * Meta information extracted from the WSDL
     * - documentation: Firma Cari Kartları Detaylarıyla Listeler.
     * @param GetCoEntity $parameters
     * @return GetCoEntityResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetCoEntity(GetCoEntity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetCoEntity', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetEntityCode $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetEntityCode(GetEntityCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetEntityCode', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetEntityExtraAction $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetEntityExtraAction(GetEntityExtraAction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetEntityExtraAction', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetBwhItemDetail
     * Meta information extracted from the WSDL
     * - documentation: İşyeri Depo Stok Detay Bilgileri
     * @param GetBwhItemDetail $parameters
     * @return GetBwhItemDetailResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetBwhItemDetail(GetBwhItemDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetBwhItemDetail', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetEDespatchHTMLByETTN $parameters
     * @return bool|GetAccMMResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityCodeResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetObjectWSDLResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetEDespatchHTMLByETTN(GetEDespatchHTMLByETTN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetEDespatchHTMLByETTN', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetItem $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetItem(GetItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetItem', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetExpense $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetExpense(GetExpense $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetExpense', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetItemUnitPriceTra $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityCodeResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetObjectWSDLResponse|GetTableValuesResponse
     */
    public function GetItemUnitPriceTra(GetItemUnitPriceTra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetItemUnitPriceTra', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetBranchExpenseList $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetBranchExpenseList(GetBranchExpenseList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetBranchExpenseList', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetBranchItemList $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetBranchItemList(GetBranchItemList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetBranchItemList', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetWaybill $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetWaybill(GetWaybill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetWaybill', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetItemM
     * Meta information extracted from the WSDL
     * - documentation: Stok Hareket Kayıtlarını Detaylarıyla Listeler.
     * @param GetItemM $parameters
     * @return GetItemMResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetItemM(GetItemM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetItemM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetItemImage $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccTypeResponse|GetCompanyListResponse|GetEDespatchHTMLByETTNResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetItemImage(GetItemImage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetItemImage', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetItemList
     * Meta information extracted from the WSDL
     * - documentation: Ürün Bilgileri
     * @param GetItemList $parameters
     * @return GetItemListResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetItemList(GetItemList $parameters)
    {
        try {
            $res = $this->getSoapClient()->__soapCall('GetItemList', array(
                $parameters,
            ), array(), array(), $this->outputHeaders);
            /*
             $xml =  $this->getSoapClient()->__getLastResponse();
             file_put_contents("res.xml",$xml);
             $xml =  $this->getSoapClient()->__getLastRequest();
             file_put_contents("req.xml",$xml);
             exit(0);
            */
            $this->setResult($res);
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetItemListCount
     * Meta information extracted from the WSDL
     * - documentation: Ürün Toplam Kayıt Sayısı Alma
     * @param GetItemListCount $parameters
     * @return GetItemListCountResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetItemListCount(GetItemListCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetItemListCount', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetTableValues
     * Meta information extracted from the WSDL
     * - documentation: Kullanıcıdan girilen değerlerin WHERE Clause oluşmasını sağlayarak DataTable
     * @param GetTableValues $parameters
     * @return GetTableValuesResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetTableValues(GetTableValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetTableValues', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetDataTableWithPagingSQL $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetDataTableWithPagingSQL(GetDataTableWithPagingSQL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetDataTableWithPagingSQL', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetFuncValues
     * Meta information extracted from the WSDL
     * - documentation: Kullanıcıdan girilen değerlerin WHERE Clause oluşmasını sağlayarak DataTable döndürür.
     * @param GetFuncValues $parameters
     * @return GetFuncValuesResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetFuncValues(GetFuncValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetFuncValues', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetDataTableWithSQL $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetDataTableWithSQL(GetDataTableWithSQL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetDataTableWithSQL', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetBranchList
     * Meta information extracted from the WSDL
     * - documentation: İşyeri Listesi
     * @param GetBranchList $parameters
     * @return GetBranchListResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetBranchList(GetBranchList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetBranchList', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetCompanyList $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEDespatchHTMLByETTNResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetCompanyList(GetCompanyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetCompanyList', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetEInvoiceHTML $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse|GetTableValuesResponse
     */
    public function GetEInvoiceHTML(GetEInvoiceHTML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetEInvoiceHTML', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetObjectToDataSet $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityCodeResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetObjectWSDLResponse|GetTableValuesResponse
     */
    public function GetObjectToDataSet(GetObjectToDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetObjectToDataSet', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetObjectWSDL
     * @param GetObjectWSDL $parameters
     * @return GetObjectWSDLResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetObjectWSDL(GetObjectWSDL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetObjectWSDL', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetPrdBomM
     * Meta information extracted from the WSDL
     * - documentation: Ürün Ağacı Listeler [Üretim Yönetimi]
     * @param GetPrdBomM $parameters
     * @return GetPrdBomMResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetPrdBomM(GetPrdBomM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetPrdBomM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named GetPrdWorderM
     * Meta information extracted from the WSDL
     * - documentation: İş Emri Kayıtlarını Listeler [Üretim Yönetimi]
     * @param GetPrdWorderM $parameters
     * @return GetPrdWorderMResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function GetPrdWorderM(GetPrdWorderM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetPrdWorderM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * @param GetEInvoiceUser $parameters
     * @return bool|GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBwhItemDetailResponse|GetCompanyListResponse|GetEntityExtraActionResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetOrderMResponse
     */
    public function GetEInvoiceUser(GetEInvoiceUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('GetEInvoiceUser', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Returns the result
     * @return GetAccMMResponse|GetAccResponse|GetBankAccResponse|GetBankAccTypeResponse|GetBranchExpenseListResponse|GetBranchItemListResponse|GetBranchListResponse|GetBwhItemDetailResponse|GetCoEntityResponse|GetCompanyListResponse|GetDataTableWithPagingSQLResponse|GetDataTableWithSQLResponse|GetEDespatchHTMLByETTNResponse|GetEInvoiceHTMLResponse|GetEInvoiceUserResponse|GetEntityCodeResponse|GetEntityExtraActionResponse|GetEntityResponse|GetExpenseResponse|GetFinanceResponse|GetFuncValuesResponse|GetInvoiceResponse|GetItemImageResponse|GetItemListCountResponse|GetItemListResponse|GetItemMResponse|GetItemResponse|GetItemUnitPriceTraResponse|GetObjectToDataSetResponse|GetObjectWSDLResponse|GetOrderMResponse|GetPrdBomMResponse|GetPrdWorderMResponse|GetTableValuesResponse|GetWaybillResponse
     * @see AbstractSoapClientBase::getResult()
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
