<?php

namespace Gek\UyumBahceGet\EnumType;

use WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InvoiceTypes EnumType
 * @subpackage Enumerations
 */
class InvoiceTypes extends AbstractStructEnumBase
{
    /**
     * Constant for value 'BaseInvoice'
     * @return string 'BaseInvoice'
     */
    const VALUE_BASE_INVOICE = 'BaseInvoice';
    /**
     * Constant for value 'ComercialInvoice'
     * @return string 'ComercialInvoice'
     */
    const VALUE_COMERCIAL_INVOICE = 'ComercialInvoice';
    /**
     * Constant for value 'InvoiceWithPassanger'
     * @return string 'InvoiceWithPassanger'
     */
    const VALUE_INVOICE_WITH_PASSANGER = 'InvoiceWithPassanger';
    /**
     * Constant for value 'Export'
     * @return string 'Export'
     */
    const VALUE_EXPORT = 'Export';
    /**
     * Constant for value 'eArchive'
     * @return string 'eArchive'
     */
    const VALUE_E_ARCHIVE = 'eArchive';
    /**
     * Constant for value 'Hks'
     * @return string 'Hks'
     */
    const VALUE_HKS = 'Hks';

    /**
     * Return allowed values
     * @return string[]
     * @uses self::VALUE_COMERCIAL_INVOICE
     * @uses self::VALUE_INVOICE_WITH_PASSANGER
     * @uses self::VALUE_EXPORT
     * @uses self::VALUE_E_ARCHIVE
     * @uses self::VALUE_HKS
     * @uses self::VALUE_BASE_INVOICE
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASE_INVOICE,
            self::VALUE_COMERCIAL_INVOICE,
            self::VALUE_INVOICE_WITH_PASSANGER,
            self::VALUE_EXPORT,
            self::VALUE_E_ARCHIVE,
            self::VALUE_HKS,
        );
    }
}
