<?php

namespace Gek\UyumBahceGet\EnumType;

use WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DocumentResponseEntityStatus EnumType
 * @subpackage Enumerations
 */
class DocumentResponseEntityStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Waiting'
     * @return string 'Waiting'
     */
    const VALUE_WAITING = 'Waiting';
    /**
     * Constant for value 'Queued'
     * @return string 'Queued'
     */
    const VALUE_QUEUED = 'Queued';
    /**
     * Constant for value 'Processing'
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Constant for value 'SentToGib'
     * @return string 'SentToGib'
     */
    const VALUE_SENT_TO_GIB = 'SentToGib';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';

    /**
     * Return allowed values
     * @return string[]
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_SENT_TO_GIB
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_WAITING
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WAITING,
            self::VALUE_QUEUED,
            self::VALUE_PROCESSING,
            self::VALUE_SENT_TO_GIB,
            self::VALUE_SUCCESS,
            self::VALUE_ERROR,
        );
    }
}
