<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\WherePropertyClause;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWherePropertyClause ArrayType
 * @subpackage Arrays
 */
class ArrayOfWherePropertyClause extends AbstractStructArrayBase
{
    /**
     * The WherePropertyClause
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var WherePropertyClause[]
     */
    public $WherePropertyClause;

    /**
     * Constructor method for ArrayOfWherePropertyClause
     * @param WherePropertyClause[] $wherePropertyClause
     * @uses ArrayOfWherePropertyClause::setWherePropertyClause()
     */
    public function __construct(array $wherePropertyClause = array())
    {
        $this
            ->setWherePropertyClause($wherePropertyClause);
    }

    /**
     * Get WherePropertyClause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return WherePropertyClause[]|null
     */
    public function getWherePropertyClause()
    {
        return isset($this->WherePropertyClause) ? $this->WherePropertyClause : null;
    }

    /**
     * This method is responsible for validating the values passed to the setWherePropertyClause method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWherePropertyClause method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWherePropertyClauseForArrayConstraintsFromSetWherePropertyClause(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWherePropertyClauseWherePropertyClauseItem) {
            // validation for constraint: itemType
            if (!$arrayOfWherePropertyClauseWherePropertyClauseItem instanceof WherePropertyClause) {
                $invalidValues[] = is_object($arrayOfWherePropertyClauseWherePropertyClauseItem) ? get_class($arrayOfWherePropertyClauseWherePropertyClauseItem) : sprintf('%s(%s)', gettype($arrayOfWherePropertyClauseWherePropertyClauseItem), var_export($arrayOfWherePropertyClauseWherePropertyClauseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WherePropertyClause property can only contain items of type \Gek\UyumBahceGet\StructType\WherePropertyClause, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set WherePropertyClause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param WherePropertyClause[] $wherePropertyClause
     * @return ArrayOfWherePropertyClause
     * @throws InvalidArgumentException
     */
    public function setWherePropertyClause(array $wherePropertyClause = array())
    {
        // validation for constraint: array
        if ('' !== ($wherePropertyClauseArrayErrorMessage = self::validateWherePropertyClauseForArrayConstraintsFromSetWherePropertyClause($wherePropertyClause))) {
            throw new InvalidArgumentException($wherePropertyClauseArrayErrorMessage, __LINE__);
        }
        if (is_null($wherePropertyClause) || (is_array($wherePropertyClause) && empty($wherePropertyClause))) {
            unset($this->WherePropertyClause);
        } else {
            $this->WherePropertyClause = $wherePropertyClause;
        }
        return $this;
    }

    /**
     * Add item to WherePropertyClause value
     * @param WherePropertyClause $item
     * @return ArrayOfWherePropertyClause
     * @throws InvalidArgumentException
     */
    public function addToWherePropertyClause(WherePropertyClause $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof WherePropertyClause) {
            throw new InvalidArgumentException(sprintf('The WherePropertyClause property can only contain items of type \Gek\UyumBahceGet\StructType\WherePropertyClause, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WherePropertyClause[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return WherePropertyClause|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return WherePropertyClause|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return WherePropertyClause|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return WherePropertyClause|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return WherePropertyClause|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string WherePropertyClause
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'WherePropertyClause';
    }
}
