<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\WhereClause;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWhereClause ArrayType
 * @subpackage Arrays
 */
class ArrayOfWhereClause extends AbstractStructArrayBase
{
    /**
     * The WhereClause
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var WhereClause[]
     */
    public $WhereClause;

    /**
     * Constructor method for ArrayOfWhereClause
     * @param WhereClause[] $whereClause
     * @uses ArrayOfWhereClause::setWhereClause()
     */
    public function __construct(array $whereClause = array())
    {
        $this
            ->setWhereClause($whereClause);
    }

    /**
     * Get WhereClause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return WhereClause[]|null
     */
    public function getWhereClause()
    {
        return isset($this->WhereClause) ? $this->WhereClause : null;
    }

    /**
     * This method is responsible for validating the values passed to the setWhereClause method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWhereClause method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWhereClauseForArrayConstraintsFromSetWhereClause(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWhereClauseWhereClauseItem) {
            // validation for constraint: itemType
            if (!$arrayOfWhereClauseWhereClauseItem instanceof WhereClause) {
                $invalidValues[] = is_object($arrayOfWhereClauseWhereClauseItem) ? get_class($arrayOfWhereClauseWhereClauseItem) : sprintf('%s(%s)', gettype($arrayOfWhereClauseWhereClauseItem), var_export($arrayOfWhereClauseWhereClauseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WhereClause property can only contain items of type \Gek\UyumBahceGet\StructType\WhereClause, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set WhereClause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param WhereClause[] $whereClause
     * @return ArrayOfWhereClause
     * @throws InvalidArgumentException
     */
    public function setWhereClause(array $whereClause = array())
    {
        // validation for constraint: array
        if ('' !== ($whereClauseArrayErrorMessage = self::validateWhereClauseForArrayConstraintsFromSetWhereClause($whereClause))) {
            throw new InvalidArgumentException($whereClauseArrayErrorMessage, __LINE__);
        }
        if (is_null($whereClause) || (is_array($whereClause) && empty($whereClause))) {
            unset($this->WhereClause);
        } else {
            $this->WhereClause = $whereClause;
        }
        return $this;
    }

    /**
     * Add item to WhereClause value
     * @param WhereClause $item
     * @return ArrayOfWhereClause
     * @throws InvalidArgumentException
     */
    public function addToWhereClause(WhereClause $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof WhereClause) {
            throw new InvalidArgumentException(sprintf('The WhereClause property can only contain items of type \Gek\UyumBahceGet\StructType\WhereClause, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WhereClause[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return WhereClause|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return WhereClause|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return WhereClause|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return WhereClause|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return WhereClause|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string WhereClause
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'WhereClause';
    }
}
