<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\SrvItemPriceList;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSrvItemPriceList ArrayType
 * @subpackage Arrays
 */
class ArrayOfSrvItemPriceList extends AbstractStructArrayBase
{
    /**
     * The SrvItemPriceList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var SrvItemPriceList[]
     */
    public $SrvItemPriceList;

    /**
     * Constructor method for ArrayOfSrvItemPriceList
     * @param SrvItemPriceList[] $srvItemPriceList
     * @uses ArrayOfSrvItemPriceList::setSrvItemPriceList()
     */
    public function __construct(array $srvItemPriceList = array())
    {
        $this
            ->setSrvItemPriceList($srvItemPriceList);
    }

    /**
     * Get SrvItemPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SrvItemPriceList[]|null
     */
    public function getSrvItemPriceList()
    {
        return isset($this->SrvItemPriceList) ? $this->SrvItemPriceList : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSrvItemPriceList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSrvItemPriceList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSrvItemPriceListForArrayConstraintsFromSetSrvItemPriceList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSrvItemPriceListSrvItemPriceListItem) {
            // validation for constraint: itemType
            if (!$arrayOfSrvItemPriceListSrvItemPriceListItem instanceof SrvItemPriceList) {
                $invalidValues[] = is_object($arrayOfSrvItemPriceListSrvItemPriceListItem) ? get_class($arrayOfSrvItemPriceListSrvItemPriceListItem) : sprintf('%s(%s)', gettype($arrayOfSrvItemPriceListSrvItemPriceListItem), var_export($arrayOfSrvItemPriceListSrvItemPriceListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SrvItemPriceList property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemPriceList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SrvItemPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SrvItemPriceList[] $srvItemPriceList
     * @return ArrayOfSrvItemPriceList
     * @throws InvalidArgumentException
     */
    public function setSrvItemPriceList(array $srvItemPriceList = array())
    {
        // validation for constraint: array
        if ('' !== ($srvItemPriceListArrayErrorMessage = self::validateSrvItemPriceListForArrayConstraintsFromSetSrvItemPriceList($srvItemPriceList))) {
            throw new InvalidArgumentException($srvItemPriceListArrayErrorMessage, __LINE__);
        }
        if (is_null($srvItemPriceList) || (is_array($srvItemPriceList) && empty($srvItemPriceList))) {
            unset($this->SrvItemPriceList);
        } else {
            $this->SrvItemPriceList = $srvItemPriceList;
        }
        return $this;
    }

    /**
     * Add item to SrvItemPriceList value
     * @param SrvItemPriceList $item
     * @return ArrayOfSrvItemPriceList
     * @throws InvalidArgumentException
     */
    public function addToSrvItemPriceList(SrvItemPriceList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SrvItemPriceList) {
            throw new InvalidArgumentException(sprintf('The SrvItemPriceList property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemPriceList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SrvItemPriceList[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return SrvItemPriceList|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return SrvItemPriceList|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return SrvItemPriceList|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return SrvItemPriceList|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return SrvItemPriceList|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string SrvItemPriceList
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'SrvItemPriceList';
    }
}
