<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\SrvItemLang;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSrvItemLang ArrayType
 * @subpackage Arrays
 */
class ArrayOfSrvItemLang extends AbstractStructArrayBase
{
    /**
     * The SrvItemLang
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var SrvItemLang[]
     */
    public $SrvItemLang;

    /**
     * Constructor method for ArrayOfSrvItemLang
     * @param SrvItemLang[] $srvItemLang
     * @uses ArrayOfSrvItemLang::setSrvItemLang()
     */
    public function __construct(array $srvItemLang = array())
    {
        $this
            ->setSrvItemLang($srvItemLang);
    }

    /**
     * Get SrvItemLang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SrvItemLang[]|null
     */
    public function getSrvItemLang()
    {
        return isset($this->SrvItemLang) ? $this->SrvItemLang : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSrvItemLang method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSrvItemLang method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSrvItemLangForArrayConstraintsFromSetSrvItemLang(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSrvItemLangSrvItemLangItem) {
            // validation for constraint: itemType
            if (!$arrayOfSrvItemLangSrvItemLangItem instanceof SrvItemLang) {
                $invalidValues[] = is_object($arrayOfSrvItemLangSrvItemLangItem) ? get_class($arrayOfSrvItemLangSrvItemLangItem) : sprintf('%s(%s)', gettype($arrayOfSrvItemLangSrvItemLangItem), var_export($arrayOfSrvItemLangSrvItemLangItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SrvItemLang property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemLang, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SrvItemLang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SrvItemLang[] $srvItemLang
     * @return ArrayOfSrvItemLang
     * @throws InvalidArgumentException
     */
    public function setSrvItemLang(array $srvItemLang = array())
    {
        // validation for constraint: array
        if ('' !== ($srvItemLangArrayErrorMessage = self::validateSrvItemLangForArrayConstraintsFromSetSrvItemLang($srvItemLang))) {
            throw new InvalidArgumentException($srvItemLangArrayErrorMessage, __LINE__);
        }
        if (is_null($srvItemLang) || (is_array($srvItemLang) && empty($srvItemLang))) {
            unset($this->SrvItemLang);
        } else {
            $this->SrvItemLang = $srvItemLang;
        }
        return $this;
    }

    /**
     * Add item to SrvItemLang value
     * @param SrvItemLang $item
     * @return ArrayOfSrvItemLang
     * @throws InvalidArgumentException
     */
    public function addToSrvItemLang(SrvItemLang $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SrvItemLang) {
            throw new InvalidArgumentException(sprintf('The SrvItemLang property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemLang, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SrvItemLang[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return SrvItemLang|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return SrvItemLang|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return SrvItemLang|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return SrvItemLang|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return SrvItemLang|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string SrvItemLang
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'SrvItemLang';
    }
}
