<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\SrvItemBarcode;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSrvItemBarcode ArrayType
 * @subpackage Arrays
 */
class ArrayOfSrvItemBarcode extends AbstractStructArrayBase
{
    /**
     * The SrvItemBarcode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var SrvItemBarcode[]
     */
    public $SrvItemBarcode;

    /**
     * Constructor method for ArrayOfSrvItemBarcode
     * @param SrvItemBarcode[] $srvItemBarcode
     * @uses ArrayOfSrvItemBarcode::setSrvItemBarcode()
     */
    public function __construct(array $srvItemBarcode = array())
    {
        $this
            ->setSrvItemBarcode($srvItemBarcode);
    }

    /**
     * Get SrvItemBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SrvItemBarcode[]|null
     */
    public function getSrvItemBarcode()
    {
        return isset($this->SrvItemBarcode) ? $this->SrvItemBarcode : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSrvItemBarcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSrvItemBarcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSrvItemBarcodeForArrayConstraintsFromSetSrvItemBarcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSrvItemBarcodeSrvItemBarcodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSrvItemBarcodeSrvItemBarcodeItem instanceof SrvItemBarcode) {
                $invalidValues[] = is_object($arrayOfSrvItemBarcodeSrvItemBarcodeItem) ? get_class($arrayOfSrvItemBarcodeSrvItemBarcodeItem) : sprintf('%s(%s)', gettype($arrayOfSrvItemBarcodeSrvItemBarcodeItem), var_export($arrayOfSrvItemBarcodeSrvItemBarcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SrvItemBarcode property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemBarcode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SrvItemBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SrvItemBarcode[] $srvItemBarcode
     * @return ArrayOfSrvItemBarcode
     * @throws InvalidArgumentException
     */
    public function setSrvItemBarcode(array $srvItemBarcode = array())
    {
        // validation for constraint: array
        if ('' !== ($srvItemBarcodeArrayErrorMessage = self::validateSrvItemBarcodeForArrayConstraintsFromSetSrvItemBarcode($srvItemBarcode))) {
            throw new InvalidArgumentException($srvItemBarcodeArrayErrorMessage, __LINE__);
        }
        if (is_null($srvItemBarcode) || (is_array($srvItemBarcode) && empty($srvItemBarcode))) {
            unset($this->SrvItemBarcode);
        } else {
            $this->SrvItemBarcode = $srvItemBarcode;
        }
        return $this;
    }

    /**
     * Add item to SrvItemBarcode value
     * @param SrvItemBarcode $item
     * @return ArrayOfSrvItemBarcode
     * @throws InvalidArgumentException
     */
    public function addToSrvItemBarcode(SrvItemBarcode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SrvItemBarcode) {
            throw new InvalidArgumentException(sprintf('The SrvItemBarcode property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemBarcode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SrvItemBarcode[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return SrvItemBarcode|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return SrvItemBarcode|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return SrvItemBarcode|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return SrvItemBarcode|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return SrvItemBarcode|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string SrvItemBarcode
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'SrvItemBarcode';
    }
}
