<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\SrvItemAttribute;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSrvItemAttribute ArrayType
 * @subpackage Arrays
 */
class ArrayOfSrvItemAttribute extends AbstractStructArrayBase
{
    /**
     * The SrvItemAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var SrvItemAttribute[]
     */
    public $SrvItemAttribute;

    /**
     * Constructor method for ArrayOfSrvItemAttribute
     * @param SrvItemAttribute[] $srvItemAttribute
     * @uses ArrayOfSrvItemAttribute::setSrvItemAttribute()
     */
    public function __construct(array $srvItemAttribute = array())
    {
        $this
            ->setSrvItemAttribute($srvItemAttribute);
    }

    /**
     * Get SrvItemAttribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SrvItemAttribute[]|null
     */
    public function getSrvItemAttribute()
    {
        return isset($this->SrvItemAttribute) ? $this->SrvItemAttribute : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSrvItemAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSrvItemAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSrvItemAttributeForArrayConstraintsFromSetSrvItemAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSrvItemAttributeSrvItemAttributeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSrvItemAttributeSrvItemAttributeItem instanceof SrvItemAttribute) {
                $invalidValues[] = is_object($arrayOfSrvItemAttributeSrvItemAttributeItem) ? get_class($arrayOfSrvItemAttributeSrvItemAttributeItem) : sprintf('%s(%s)', gettype($arrayOfSrvItemAttributeSrvItemAttributeItem), var_export($arrayOfSrvItemAttributeSrvItemAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SrvItemAttribute property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SrvItemAttribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SrvItemAttribute[] $srvItemAttribute
     * @return ArrayOfSrvItemAttribute
     * @throws InvalidArgumentException
     */
    public function setSrvItemAttribute(array $srvItemAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($srvItemAttributeArrayErrorMessage = self::validateSrvItemAttributeForArrayConstraintsFromSetSrvItemAttribute($srvItemAttribute))) {
            throw new InvalidArgumentException($srvItemAttributeArrayErrorMessage, __LINE__);
        }
        if (is_null($srvItemAttribute) || (is_array($srvItemAttribute) && empty($srvItemAttribute))) {
            unset($this->SrvItemAttribute);
        } else {
            $this->SrvItemAttribute = $srvItemAttribute;
        }
        return $this;
    }

    /**
     * Add item to SrvItemAttribute value
     * @param SrvItemAttribute $item
     * @return ArrayOfSrvItemAttribute
     * @throws InvalidArgumentException
     */
    public function addToSrvItemAttribute(SrvItemAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SrvItemAttribute) {
            throw new InvalidArgumentException(sprintf('The SrvItemAttribute property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItemAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SrvItemAttribute[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return SrvItemAttribute|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return SrvItemAttribute|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return SrvItemAttribute|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return SrvItemAttribute|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return SrvItemAttribute|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string SrvItemAttribute
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'SrvItemAttribute';
    }
}
