<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\SrvItem;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSrvItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSrvItem extends AbstractStructArrayBase
{
    /**
     * The SrvItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var SrvItem[]
     */
    public $SrvItem;

    /**
     * Constructor method for ArrayOfSrvItem
     * @param SrvItem[] $srvItem
     * @uses ArrayOfSrvItem::setSrvItem()
     */
    public function __construct(array $srvItem = array())
    {
        $this
            ->setSrvItem($srvItem);
    }

    /**
     * Get SrvItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SrvItem[]|null
     */
    public function getSrvItem()
    {
        return isset($this->SrvItem) ? $this->SrvItem : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSrvItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSrvItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSrvItemForArrayConstraintsFromSetSrvItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSrvItemSrvItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSrvItemSrvItemItem instanceof SrvItem) {
                $invalidValues[] = is_object($arrayOfSrvItemSrvItemItem) ? get_class($arrayOfSrvItemSrvItemItem) : sprintf('%s(%s)', gettype($arrayOfSrvItemSrvItemItem), var_export($arrayOfSrvItemSrvItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SrvItem property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SrvItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SrvItem[] $srvItem
     * @return ArrayOfSrvItem
     * @throws InvalidArgumentException
     */
    public function setSrvItem(array $srvItem = array())
    {
        // validation for constraint: array
        if ('' !== ($srvItemArrayErrorMessage = self::validateSrvItemForArrayConstraintsFromSetSrvItem($srvItem))) {
            throw new InvalidArgumentException($srvItemArrayErrorMessage, __LINE__);
        }
        if (is_null($srvItem) || (is_array($srvItem) && empty($srvItem))) {
            unset($this->SrvItem);
        } else {
            $this->SrvItem = $srvItem;
        }
        return $this;
    }

    /**
     * Add item to SrvItem value
     * @param SrvItem $item
     * @return ArrayOfSrvItem
     * @throws InvalidArgumentException
     */
    public function addToSrvItem(SrvItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SrvItem) {
            throw new InvalidArgumentException(sprintf('The SrvItem property can only contain items of type \Gek\UyumBahceGet\StructType\SrvItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SrvItem[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return SrvItem|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return SrvItem|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return SrvItem|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return SrvItem|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return SrvItem|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string SrvItem
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'SrvItem';
    }
}
