<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\SrvBwhItem;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSrvBwhItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSrvBwhItem extends AbstractStructArrayBase
{
    /**
     * The SrvBwhItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var SrvBwhItem[]
     */
    public $SrvBwhItem;

    /**
     * Constructor method for ArrayOfSrvBwhItem
     * @param SrvBwhItem[] $srvBwhItem
     * @uses ArrayOfSrvBwhItem::setSrvBwhItem()
     */
    public function __construct(array $srvBwhItem = array())
    {
        $this
            ->setSrvBwhItem($srvBwhItem);
    }

    /**
     * Get SrvBwhItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SrvBwhItem[]|null
     */
    public function getSrvBwhItem()
    {
        return isset($this->SrvBwhItem) ? $this->SrvBwhItem : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSrvBwhItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSrvBwhItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSrvBwhItemForArrayConstraintsFromSetSrvBwhItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSrvBwhItemSrvBwhItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSrvBwhItemSrvBwhItemItem instanceof SrvBwhItem) {
                $invalidValues[] = is_object($arrayOfSrvBwhItemSrvBwhItemItem) ? get_class($arrayOfSrvBwhItemSrvBwhItemItem) : sprintf('%s(%s)', gettype($arrayOfSrvBwhItemSrvBwhItemItem), var_export($arrayOfSrvBwhItemSrvBwhItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SrvBwhItem property can only contain items of type \Gek\UyumBahceGet\StructType\SrvBwhItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SrvBwhItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SrvBwhItem[] $srvBwhItem
     * @return ArrayOfSrvBwhItem
     * @throws InvalidArgumentException
     */
    public function setSrvBwhItem(array $srvBwhItem = array())
    {
        // validation for constraint: array
        if ('' !== ($srvBwhItemArrayErrorMessage = self::validateSrvBwhItemForArrayConstraintsFromSetSrvBwhItem($srvBwhItem))) {
            throw new InvalidArgumentException($srvBwhItemArrayErrorMessage, __LINE__);
        }
        if (is_null($srvBwhItem) || (is_array($srvBwhItem) && empty($srvBwhItem))) {
            unset($this->SrvBwhItem);
        } else {
            $this->SrvBwhItem = $srvBwhItem;
        }
        return $this;
    }

    /**
     * Add item to SrvBwhItem value
     * @param SrvBwhItem $item
     * @return ArrayOfSrvBwhItem
     * @throws InvalidArgumentException
     */
    public function addToSrvBwhItem(SrvBwhItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SrvBwhItem) {
            throw new InvalidArgumentException(sprintf('The SrvBwhItem property can only contain items of type \Gek\UyumBahceGet\StructType\SrvBwhItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SrvBwhItem[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return SrvBwhItem|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return SrvBwhItem|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return SrvBwhItem|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return SrvBwhItem|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return SrvBwhItem|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string SrvBwhItem
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'SrvBwhItem';
    }
}
