<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\ItemImageClass;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemImageClass ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemImageClass extends AbstractStructArrayBase
{
    /**
     * The ItemImageClass
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ItemImageClass[]
     */
    public $ItemImageClass;

    /**
     * Constructor method for ArrayOfItemImageClass
     * @param ItemImageClass[] $itemImageClass
     * @uses ArrayOfItemImageClass::setItemImageClass()
     */
    public function __construct(array $itemImageClass = array())
    {
        $this
            ->setItemImageClass($itemImageClass);
    }

    /**
     * Get ItemImageClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ItemImageClass[]|null
     */
    public function getItemImageClass()
    {
        return isset($this->ItemImageClass) ? $this->ItemImageClass : null;
    }

    /**
     * This method is responsible for validating the values passed to the setItemImageClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemImageClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemImageClassForArrayConstraintsFromSetItemImageClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemImageClassItemImageClassItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemImageClassItemImageClassItem instanceof ItemImageClass) {
                $invalidValues[] = is_object($arrayOfItemImageClassItemImageClassItem) ? get_class($arrayOfItemImageClassItemImageClassItem) : sprintf('%s(%s)', gettype($arrayOfItemImageClassItemImageClassItem), var_export($arrayOfItemImageClassItemImageClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemImageClass property can only contain items of type \Gek\UyumBahceGet\StructType\ItemImageClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ItemImageClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ItemImageClass[] $itemImageClass
     * @return ArrayOfItemImageClass
     * @throws InvalidArgumentException
     */
    public function setItemImageClass(array $itemImageClass = array())
    {
        // validation for constraint: array
        if ('' !== ($itemImageClassArrayErrorMessage = self::validateItemImageClassForArrayConstraintsFromSetItemImageClass($itemImageClass))) {
            throw new InvalidArgumentException($itemImageClassArrayErrorMessage, __LINE__);
        }
        if (is_null($itemImageClass) || (is_array($itemImageClass) && empty($itemImageClass))) {
            unset($this->ItemImageClass);
        } else {
            $this->ItemImageClass = $itemImageClass;
        }
        return $this;
    }

    /**
     * Add item to ItemImageClass value
     * @param ItemImageClass $item
     * @return ArrayOfItemImageClass
     * @throws InvalidArgumentException
     */
    public function addToItemImageClass(ItemImageClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemImageClass) {
            throw new InvalidArgumentException(sprintf('The ItemImageClass property can only contain items of type \Gek\UyumBahceGet\StructType\ItemImageClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemImageClass[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return ItemImageClass|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return ItemImageClass|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return ItemImageClass|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return ItemImageClass|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return ItemImageClass|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string ItemImageClass
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'ItemImageClass';
    }
}
