<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\DicKeyValues;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDicKeyValues ArrayType
 * @subpackage Arrays
 */
class ArrayOfDicKeyValues extends AbstractStructArrayBase
{
    /**
     * The DicKeyValues
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var DicKeyValues[]
     */
    public $DicKeyValues;

    /**
     * Constructor method for ArrayOfDicKeyValues
     * @param DicKeyValues[] $dicKeyValues
     * @uses ArrayOfDicKeyValues::setDicKeyValues()
     */
    public function __construct(array $dicKeyValues = array())
    {
        $this
            ->setDicKeyValues($dicKeyValues);
    }

    /**
     * Get DicKeyValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DicKeyValues[]|null
     */
    public function getDicKeyValues()
    {
        return isset($this->DicKeyValues) ? $this->DicKeyValues : null;
    }

    /**
     * This method is responsible for validating the values passed to the setDicKeyValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDicKeyValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDicKeyValuesForArrayConstraintsFromSetDicKeyValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDicKeyValuesDicKeyValuesItem) {
            // validation for constraint: itemType
            if (!$arrayOfDicKeyValuesDicKeyValuesItem instanceof DicKeyValues) {
                $invalidValues[] = is_object($arrayOfDicKeyValuesDicKeyValuesItem) ? get_class($arrayOfDicKeyValuesDicKeyValuesItem) : sprintf('%s(%s)', gettype($arrayOfDicKeyValuesDicKeyValuesItem), var_export($arrayOfDicKeyValuesDicKeyValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DicKeyValues property can only contain items of type \Gek\UyumBahceGet\StructType\DicKeyValues, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DicKeyValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param DicKeyValues[] $dicKeyValues
     * @return ArrayOfDicKeyValues
     * @throws InvalidArgumentException
     */
    public function setDicKeyValues(array $dicKeyValues = array())
    {
        // validation for constraint: array
        if ('' !== ($dicKeyValuesArrayErrorMessage = self::validateDicKeyValuesForArrayConstraintsFromSetDicKeyValues($dicKeyValues))) {
            throw new InvalidArgumentException($dicKeyValuesArrayErrorMessage, __LINE__);
        }
        if (is_null($dicKeyValues) || (is_array($dicKeyValues) && empty($dicKeyValues))) {
            unset($this->DicKeyValues);
        } else {
            $this->DicKeyValues = $dicKeyValues;
        }
        return $this;
    }

    /**
     * Add item to DicKeyValues value
     * @param DicKeyValues $item
     * @return ArrayOfDicKeyValues
     * @throws InvalidArgumentException
     */
    public function addToDicKeyValues(DicKeyValues $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DicKeyValues) {
            throw new InvalidArgumentException(sprintf('The DicKeyValues property can only contain items of type \Gek\UyumBahceGet\StructType\DicKeyValues, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DicKeyValues[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return DicKeyValues|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return DicKeyValues|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return DicKeyValues|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return DicKeyValues|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return DicKeyValues|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string DicKeyValues
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'DicKeyValues';
    }
}
