<?php

namespace Gek\UyumBahceGet\ArrayType;

use Gek\UyumBahceGet\StructType\BaseClass;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBaseClass ArrayType
 * @subpackage Arrays
 */
class ArrayOfBaseClass extends AbstractStructArrayBase
{
    /**
     * The BaseClass
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var BaseClass[]
     */
    public $BaseClass;

    /**
     * Constructor method for ArrayOfBaseClass
     * @param BaseClass[] $baseClass
     * @uses ArrayOfBaseClass::setBaseClass()
     */
    public function __construct(array $baseClass = array())
    {
        $this
            ->setBaseClass($baseClass);
    }

    /**
     * Get BaseClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return BaseClass[]|null
     */
    public function getBaseClass()
    {
        return isset($this->BaseClass) ? $this->BaseClass : null;
    }

    /**
     * This method is responsible for validating the values passed to the setBaseClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseClassForArrayConstraintsFromSetBaseClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBaseClassBaseClassItem) {
            // validation for constraint: itemType
            if (!$arrayOfBaseClassBaseClassItem instanceof BaseClass) {
                $invalidValues[] = is_object($arrayOfBaseClassBaseClassItem) ? get_class($arrayOfBaseClassBaseClassItem) : sprintf('%s(%s)', gettype($arrayOfBaseClassBaseClassItem), var_export($arrayOfBaseClassBaseClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaseClass property can only contain items of type \Gek\UyumBahceGet\StructType\BaseClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set BaseClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param BaseClass[] $baseClass
     * @return ArrayOfBaseClass
     * @throws InvalidArgumentException
     */
    public function setBaseClass(array $baseClass = array())
    {
        // validation for constraint: array
        if ('' !== ($baseClassArrayErrorMessage = self::validateBaseClassForArrayConstraintsFromSetBaseClass($baseClass))) {
            throw new InvalidArgumentException($baseClassArrayErrorMessage, __LINE__);
        }
        if (is_null($baseClass) || (is_array($baseClass) && empty($baseClass))) {
            unset($this->BaseClass);
        } else {
            $this->BaseClass = $baseClass;
        }
        return $this;
    }

    /**
     * Add item to BaseClass value
     * @param BaseClass $item
     * @return ArrayOfBaseClass
     * @throws InvalidArgumentException
     */
    public function addToBaseClass(BaseClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof BaseClass) {
            throw new InvalidArgumentException(sprintf('The BaseClass property can only contain items of type \Gek\UyumBahceGet\StructType\BaseClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaseClass[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return BaseClass|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return BaseClass|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return BaseClass|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return BaseClass|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return BaseClass|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string BaseClass
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'BaseClass';
    }
}
