<?php

use Gek\UyumBahceGet\ArrayType\ArrayOfString;
use Gek\UyumBahceGet\ClassMap;
use Gek\UyumBahceGet\GekDateTime;
use Gek\UyumBahceGet\ServiceType\Get;
use Gek\UyumBahceGet\StructType\GetItemList;
use Gek\UyumBahceGet\StructType\GetSrvItemContext;
use Gek\UyumBahceGet\StructType\UPORequestOfGetSrvItemContext;
use WsdlToPhp\PackageBase\AbstractSoapClientBase;

require_once __DIR__ . '/vendor/autoload.php';

$options = array(
    AbstractSoapClientBase::WSDL_URL => 'http://testerp.agac.istanbul/webservice/erp/uyumgetwebservice.asmx?wsdl',
    AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);

$get = new Get($options);

$pricelistcode = array("2001-004");
$dateTime1 =  GekDateTime::create(2010,05,20);
//$dateTime1 = $dateTime1->format("c");


$dateTime2 = GekDateTime::create(2022,05,20);
//$dateTime2 = $dateTime2->format("c");

$dateTime3 = GekDateTime::create(2010,05,20);
//$dateTime3 = $dateTime3->format("c");

$dateTime4 = GekDateTime::create(2022,05,20);
//$dateTime4 = $dateTime4->format("c");

$req = new GetItemList();
$param = new UPORequestOfGetSrvItemContext();
$param->setUsername("esatis")
    ->setPassword("esatis123")
    ->setPageNumber(1)
    ->setPageItemCount(30);
$vlu = new GetSrvItemContext();
$vlu->setBranchCode("100 95")
    ->setPriceListCode(new ArrayOfString($pricelistcode))
    ->setPriceListStartDate($dateTime1)
    ->setPriceListEndDate($dateTime2)
    ->setItemStartDate($dateTime3)
    ->setItemEndDate($dateTime4)
    ->setWhouseCode("8013")
    ->setItemCode("MVS.THM.YKSK.01");
$param->setValue($vlu);
$req->setParam($param);

if ($get->GetItemList($req) !== false) {
    var_dump($get->getResult()->getGetItemListResult()->getValue()->getSrvItem()[0]);
} else {
    print_r($get->getLastError());
}