<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrdWorderMDef StructType
 * @subpackage Structs
 */
class PrdWorderMDef extends AbstractStructBase
{
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CoId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The UnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitId;
    /**
     * The WoTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WoTypeId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The BomMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BomMId;
    /**
     * The RouteMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RouteMId;
    /**
     * The ProductRouteMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductRouteMId;
    /**
     * The WoOpenDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WoOpenDate;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EntityId;
    /**
     * The SourceApp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceApp;
    /**
     * The SourceMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceMId;
    /**
     * The SourceDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceDId;
    /**
     * The WorderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorderNo;

    /**
     * Constructor method for PrdWorderMDef
     * @param int $coId
     * @param int $branchId
     * @param int $itemId
     * @param int $unitId
     * @param int $woTypeId
     * @param float $qty
     * @param int $bomMId
     * @param int $routeMId
     * @param int $productRouteMId
     * @param string|GekDateTime $woOpenDate
     * @param string|GekDateTime $startDate
     * @param string|GekDateTime $endDate
     * @param int $entityId
     * @param int $sourceApp
     * @param int $sourceMId
     * @param int $sourceDId
     * @param string $worderNo
     * @uses PrdWorderMDef::setCoId()
     * @uses PrdWorderMDef::setBranchId()
     * @uses PrdWorderMDef::setItemId()
     * @uses PrdWorderMDef::setUnitId()
     * @uses PrdWorderMDef::setWoTypeId()
     * @uses PrdWorderMDef::setQty()
     * @uses PrdWorderMDef::setBomMId()
     * @uses PrdWorderMDef::setRouteMId()
     * @uses PrdWorderMDef::setProductRouteMId()
     * @uses PrdWorderMDef::setWoOpenDate()
     * @uses PrdWorderMDef::setStartDate()
     * @uses PrdWorderMDef::setEndDate()
     * @uses PrdWorderMDef::setEntityId()
     * @uses PrdWorderMDef::setSourceApp()
     * @uses PrdWorderMDef::setSourceMId()
     * @uses PrdWorderMDef::setSourceDId()
     * @uses PrdWorderMDef::setWorderNo()
     */
    public function __construct($coId = null, $branchId = null, $itemId = null, $unitId = null, $woTypeId = null, $qty = null, $bomMId = null, $routeMId = null, $productRouteMId = null, $woOpenDate = null, $startDate = null, $endDate = null, $entityId = null, $sourceApp = null, $sourceMId = null, $sourceDId = null, $worderNo = null)
    {
        $this
            ->setCoId($coId)
            ->setBranchId($branchId)
            ->setItemId($itemId)
            ->setUnitId($unitId)
            ->setWoTypeId($woTypeId)
            ->setQty($qty)
            ->setBomMId($bomMId)
            ->setRouteMId($routeMId)
            ->setProductRouteMId($productRouteMId)
            ->setWoOpenDate($woOpenDate)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setEntityId($entityId)
            ->setSourceApp($sourceApp)
            ->setSourceMId($sourceMId)
            ->setSourceDId($sourceDId)
            ->setWorderNo($worderNo);
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return PrdWorderMDef
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return PrdWorderMDef
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return PrdWorderMDef
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get UnitId value
     * @return int
     */
    public function getUnitId()
    {
        return $this->UnitId;
    }

    /**
     * Set UnitId value
     * @param int $unitId
     * @return PrdWorderMDef
     */
    public function setUnitId($unitId = null)
    {
        // validation for constraint: int
        if (!is_null($unitId) && !(is_int($unitId) || ctype_digit($unitId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitId, true), gettype($unitId)), __LINE__);
        }
        $this->UnitId = $unitId;
        return $this;
    }

    /**
     * Get WoTypeId value
     * @return int
     */
    public function getWoTypeId()
    {
        return $this->WoTypeId;
    }

    /**
     * Set WoTypeId value
     * @param int $woTypeId
     * @return PrdWorderMDef
     */
    public function setWoTypeId($woTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($woTypeId) && !(is_int($woTypeId) || ctype_digit($woTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($woTypeId, true), gettype($woTypeId)), __LINE__);
        }
        $this->WoTypeId = $woTypeId;
        return $this;
    }

    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }

    /**
     * Set Qty value
     * @param float $qty
     * @return PrdWorderMDef
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }

    /**
     * Get BomMId value
     * @return int
     */
    public function getBomMId()
    {
        return $this->BomMId;
    }

    /**
     * Set BomMId value
     * @param int $bomMId
     * @return PrdWorderMDef
     */
    public function setBomMId($bomMId = null)
    {
        // validation for constraint: int
        if (!is_null($bomMId) && !(is_int($bomMId) || ctype_digit($bomMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bomMId, true), gettype($bomMId)), __LINE__);
        }
        $this->BomMId = $bomMId;
        return $this;
    }

    /**
     * Get RouteMId value
     * @return int
     */
    public function getRouteMId()
    {
        return $this->RouteMId;
    }

    /**
     * Set RouteMId value
     * @param int $routeMId
     * @return PrdWorderMDef
     */
    public function setRouteMId($routeMId = null)
    {
        // validation for constraint: int
        if (!is_null($routeMId) && !(is_int($routeMId) || ctype_digit($routeMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeMId, true), gettype($routeMId)), __LINE__);
        }
        $this->RouteMId = $routeMId;
        return $this;
    }

    /**
     * Get ProductRouteMId value
     * @return int
     */
    public function getProductRouteMId()
    {
        return $this->ProductRouteMId;
    }

    /**
     * Set ProductRouteMId value
     * @param int $productRouteMId
     * @return PrdWorderMDef
     */
    public function setProductRouteMId($productRouteMId = null)
    {
        // validation for constraint: int
        if (!is_null($productRouteMId) && !(is_int($productRouteMId) || ctype_digit($productRouteMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productRouteMId, true), gettype($productRouteMId)), __LINE__);
        }
        $this->ProductRouteMId = $productRouteMId;
        return $this;
    }

    /**
     * Get WoOpenDate value
     * @return string
     */
    public function getWoOpenDate()
    {
        return $this->WoOpenDate;
    }

    /**
     * Set WoOpenDate value
     * @param string|GekDateTime $woOpenDate
     * @return PrdWorderMDef
     */
    public function setWoOpenDate($woOpenDate = null)
    {
        // validation for constraint: string
        if (!is_null($woOpenDate) && !is_string($woOpenDate) && !($woOpenDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($woOpenDate, true), gettype($woOpenDate)), __LINE__);
        }
        if ($woOpenDate instanceof GekDateTime) {
            $woOpenDate = $woOpenDate->toServiceString();
        }
        $this->WoOpenDate = $woOpenDate;
        return $this;
    }

    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * Set StartDate value
     * @param string|GekDateTime $startDate
     * @return PrdWorderMDef
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate) && !($startDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if ($startDate instanceof GekDateTime) {
            $startDate = $startDate->toServiceString();
        }
        $this->StartDate = $startDate;
        return $this;
    }

    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * Set EndDate value
     * @param string|GekDateTime $endDate
     * @return PrdWorderMDef
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate) && !($endDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if ($endDate instanceof GekDateTime) {
            $endDate = $endDate->toServiceString();
        }
        $this->EndDate = $endDate;
        return $this;
    }

    /**
     * Get EntityId value
     * @return int
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }

    /**
     * Set EntityId value
     * @param int $entityId
     * @return PrdWorderMDef
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }

    /**
     * Get SourceApp value
     * @return int
     */
    public function getSourceApp()
    {
        return $this->SourceApp;
    }

    /**
     * Set SourceApp value
     * @param int $sourceApp
     * @return PrdWorderMDef
     */
    public function setSourceApp($sourceApp = null)
    {
        // validation for constraint: int
        if (!is_null($sourceApp) && !(is_int($sourceApp) || ctype_digit($sourceApp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceApp, true), gettype($sourceApp)), __LINE__);
        }
        $this->SourceApp = $sourceApp;
        return $this;
    }

    /**
     * Get SourceMId value
     * @return int
     */
    public function getSourceMId()
    {
        return $this->SourceMId;
    }

    /**
     * Set SourceMId value
     * @param int $sourceMId
     * @return PrdWorderMDef
     */
    public function setSourceMId($sourceMId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceMId) && !(is_int($sourceMId) || ctype_digit($sourceMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceMId, true), gettype($sourceMId)), __LINE__);
        }
        $this->SourceMId = $sourceMId;
        return $this;
    }

    /**
     * Get SourceDId value
     * @return int
     */
    public function getSourceDId()
    {
        return $this->SourceDId;
    }

    /**
     * Set SourceDId value
     * @param int $sourceDId
     * @return PrdWorderMDef
     */
    public function setSourceDId($sourceDId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDId) && !(is_int($sourceDId) || ctype_digit($sourceDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDId, true), gettype($sourceDId)), __LINE__);
        }
        $this->SourceDId = $sourceDId;
        return $this;
    }

    /**
     * Get WorderNo value
     * @return string|null
     */
    public function getWorderNo()
    {
        return $this->WorderNo;
    }

    /**
     * Set WorderNo value
     * @param string $worderNo
     * @return PrdWorderMDef
     */
    public function setWorderNo($worderNo = null)
    {
        // validation for constraint: string
        if (!is_null($worderNo) && !is_string($worderNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worderNo, true), gettype($worderNo)), __LINE__);
        }
        $this->WorderNo = $worderNo;
        return $this;
    }
}
