<?php

namespace Gek\UyumBahce\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonType StructType
 * @subpackage Structs
 */
class PersonType extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FirstName
     * @var FirstNameType
     */
    public $FirstName;
    /**
     * The FamilyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FamilyName
     * @var FamilyNameType
     */
    public $FamilyName;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Title
     * @var TitleType
     */
    public $Title;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:MiddleName
     * @var MiddleNameType
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NameSuffix
     * @var NameSuffixType
     */
    public $NameSuffix;
    /**
     * The NationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NationalityID
     * @var NationalityIDType
     */
    public $NationalityID;
    /**
     * The FinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var FinancialAccountType
     */
    public $FinancialAccount;
    /**
     * The IdentityDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $IdentityDocumentReference;

    /**
     * Constructor method for PersonType
     * @param FirstNameType $firstName
     * @param FamilyNameType $familyName
     * @param TitleType $title
     * @param MiddleNameType $middleName
     * @param NameSuffixType $nameSuffix
     * @param NationalityIDType $nationalityID
     * @param FinancialAccountType $financialAccount
     * @param DocumentReferenceType $identityDocumentReference
     * @uses PersonType::setFirstName()
     * @uses PersonType::setFamilyName()
     * @uses PersonType::setTitle()
     * @uses PersonType::setMiddleName()
     * @uses PersonType::setNameSuffix()
     * @uses PersonType::setNationalityID()
     * @uses PersonType::setFinancialAccount()
     * @uses PersonType::setIdentityDocumentReference()
     */
    public function __construct(FirstNameType $firstName = null, FamilyNameType $familyName = null, TitleType $title = null, MiddleNameType $middleName = null, NameSuffixType $nameSuffix = null, NationalityIDType $nationalityID = null, FinancialAccountType $financialAccount = null, DocumentReferenceType $identityDocumentReference = null)
    {
        $this
            ->setFirstName($firstName)
            ->setFamilyName($familyName)
            ->setTitle($title)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setNationalityID($nationalityID)
            ->setFinancialAccount($financialAccount)
            ->setIdentityDocumentReference($identityDocumentReference);
    }

    /**
     * Get FirstName value
     * @return FirstNameType|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * Set FirstName value
     * @param FirstNameType $firstName
     * @return PersonType
     */
    public function setFirstName(FirstNameType $firstName = null)
    {
        $this->FirstName = $firstName;
        return $this;
    }

    /**
     * Get FamilyName value
     * @return FamilyNameType|null
     */
    public function getFamilyName()
    {
        return $this->FamilyName;
    }

    /**
     * Set FamilyName value
     * @param FamilyNameType $familyName
     * @return PersonType
     */
    public function setFamilyName(FamilyNameType $familyName = null)
    {
        $this->FamilyName = $familyName;
        return $this;
    }

    /**
     * Get Title value
     * @return TitleType|null
     */
    public function getTitle()
    {
        return $this->Title;
    }

    /**
     * Set Title value
     * @param TitleType $title
     * @return PersonType
     */
    public function setTitle(TitleType $title = null)
    {
        $this->Title = $title;
        return $this;
    }

    /**
     * Get MiddleName value
     * @return MiddleNameType|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }

    /**
     * Set MiddleName value
     * @param MiddleNameType $middleName
     * @return PersonType
     */
    public function setMiddleName(MiddleNameType $middleName = null)
    {
        $this->MiddleName = $middleName;
        return $this;
    }

    /**
     * Get NameSuffix value
     * @return NameSuffixType|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }

    /**
     * Set NameSuffix value
     * @param NameSuffixType $nameSuffix
     * @return PersonType
     */
    public function setNameSuffix(NameSuffixType $nameSuffix = null)
    {
        $this->NameSuffix = $nameSuffix;
        return $this;
    }

    /**
     * Get NationalityID value
     * @return NationalityIDType|null
     */
    public function getNationalityID()
    {
        return $this->NationalityID;
    }

    /**
     * Set NationalityID value
     * @param NationalityIDType $nationalityID
     * @return PersonType
     */
    public function setNationalityID(NationalityIDType $nationalityID = null)
    {
        $this->NationalityID = $nationalityID;
        return $this;
    }

    /**
     * Get FinancialAccount value
     * @return FinancialAccountType|null
     */
    public function getFinancialAccount()
    {
        return $this->FinancialAccount;
    }

    /**
     * Set FinancialAccount value
     * @param FinancialAccountType $financialAccount
     * @return PersonType
     */
    public function setFinancialAccount(FinancialAccountType $financialAccount = null)
    {
        $this->FinancialAccount = $financialAccount;
        return $this;
    }

    /**
     * Get IdentityDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getIdentityDocumentReference()
    {
        return $this->IdentityDocumentReference;
    }

    /**
     * Set IdentityDocumentReference value
     * @param DocumentReferenceType $identityDocumentReference
     * @return PersonType
     */
    public function setIdentityDocumentReference(DocumentReferenceType $identityDocumentReference = null)
    {
        $this->IdentityDocumentReference = $identityDocumentReference;
        return $this;
    }
}
