<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailBarcode StructType
 * @subpackage Structs
 */
class OrderDetailBarcode extends AbstractStructBase
{
    /**
     * The OrderDetailId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderDetailId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;

    /**
     * Constructor method for OrderDetailBarcode
     * @param int $orderDetailId
     * @param string $barcode
     * @uses OrderDetailBarcode::setOrderDetailId()
     * @uses OrderDetailBarcode::setBarcode()
     */
    public function __construct($orderDetailId = null, $barcode = null)
    {
        $this
            ->setOrderDetailId($orderDetailId)
            ->setBarcode($barcode);
    }

    /**
     * Get OrderDetailId value
     * @return int
     */
    public function getOrderDetailId()
    {
        return $this->OrderDetailId;
    }

    /**
     * Set OrderDetailId value
     * @param int $orderDetailId
     * @return OrderDetailBarcode
     */
    public function setOrderDetailId($orderDetailId = null)
    {
        // validation for constraint: int
        if (!is_null($orderDetailId) && !(is_int($orderDetailId) || ctype_digit($orderDetailId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderDetailId, true), gettype($orderDetailId)), __LINE__);
        }
        $this->OrderDetailId = $orderDetailId;
        return $this;
    }

    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }

    /**
     * Set Barcode value
     * @param string $barcode
     * @return OrderDetailBarcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
}
