<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumericType StructType
 * @subpackage Structs
 */
class NumericType extends AbstractStructBase
{
    /**
     * The _
     * @var NumericType
     */
    public $_;
    /**
     * The format
     * @var string
     */
    public $format;

    /**
     * Constructor method for NumericType
     * @param NumericType $_
     * @param string $format
     * @uses NumericType::set_()
     * @uses NumericType::setFormat()
     */
    public function __construct(NumericType $_ = null, $format = null)
    {
        $this
            ->set_($_)
            ->setFormat($format);
    }

    /**
     * Get _ value
     * @return NumericType|null
     */
    public function get_()
    {
        return $this->_;
    }

    /**
     * Set _ value
     * @param NumericType $_
     * @return NumericType
     */
    public function set_(NumericType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }

    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }

    /**
     * Set format value
     * @param string $format
     * @return NumericType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
}
