<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Description
     * @var DescriptionType
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var NameType
     */
    public $Name;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Keyword
     * @var KeywordType
     */
    public $Keyword;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:BrandName
     * @var BrandNameType
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ModelName
     * @var ModelNameType
     */
    public $ModelName;
    /**
     * The BuyersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ItemIdentificationType
     */
    public $BuyersItemIdentification;
    /**
     * The SellersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ItemIdentificationType
     */
    public $SellersItemIdentification;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ItemIdentificationType
     */
    public $ManufacturersItemIdentification;
    /**
     * The AdditionalItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ItemIdentificationType[]
     */
    public $AdditionalItemIdentification;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CountryType
     */
    public $OriginCountry;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var CommodityClassificationType[]
     */
    public $CommodityClassification;
    /**
     * The ItemInstance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ItemInstanceType[]
     */
    public $ItemInstance;

    /**
     * Constructor method for ItemType
     * @param DescriptionType $description
     * @param NameType $name
     * @param KeywordType $keyword
     * @param BrandNameType $brandName
     * @param ModelNameType $modelName
     * @param ItemIdentificationType $buyersItemIdentification
     * @param ItemIdentificationType $sellersItemIdentification
     * @param ItemIdentificationType $manufacturersItemIdentification
     * @param ItemIdentificationType[] $additionalItemIdentification
     * @param CountryType $originCountry
     * @param CommodityClassificationType[] $commodityClassification
     * @param ItemInstanceType[] $itemInstance
     * @uses ItemType::setDescription()
     * @uses ItemType::setName()
     * @uses ItemType::setKeyword()
     * @uses ItemType::setBrandName()
     * @uses ItemType::setModelName()
     * @uses ItemType::setBuyersItemIdentification()
     * @uses ItemType::setSellersItemIdentification()
     * @uses ItemType::setManufacturersItemIdentification()
     * @uses ItemType::setAdditionalItemIdentification()
     * @uses ItemType::setOriginCountry()
     * @uses ItemType::setCommodityClassification()
     * @uses ItemType::setItemInstance()
     */
    public function __construct(DescriptionType $description = null, NameType $name = null, KeywordType $keyword = null, BrandNameType $brandName = null, ModelNameType $modelName = null, ItemIdentificationType $buyersItemIdentification = null, ItemIdentificationType $sellersItemIdentification = null, ItemIdentificationType $manufacturersItemIdentification = null, array $additionalItemIdentification = array(), CountryType $originCountry = null, array $commodityClassification = array(), array $itemInstance = array())
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setKeyword($keyword)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setAdditionalItemIdentification($additionalItemIdentification)
            ->setOriginCountry($originCountry)
            ->setCommodityClassification($commodityClassification)
            ->setItemInstance($itemInstance);
    }

    /**
     * Get Description value
     * @return DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Set Description value
     * @param DescriptionType $description
     * @return ItemType
     */
    public function setDescription(DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }

    /**
     * Get Name value
     * @return NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * Set Name value
     * @param NameType $name
     * @return ItemType
     */
    public function setName(NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }

    /**
     * Get Keyword value
     * @return KeywordType|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }

    /**
     * Set Keyword value
     * @param KeywordType $keyword
     * @return ItemType
     */
    public function setKeyword(KeywordType $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }

    /**
     * Get BrandName value
     * @return BrandNameType|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }

    /**
     * Set BrandName value
     * @param BrandNameType $brandName
     * @return ItemType
     */
    public function setBrandName(BrandNameType $brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }

    /**
     * Get ModelName value
     * @return ModelNameType|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }

    /**
     * Set ModelName value
     * @param ModelNameType $modelName
     * @return ItemType
     */
    public function setModelName(ModelNameType $modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }

    /**
     * Get BuyersItemIdentification value
     * @return ItemIdentificationType|null
     */
    public function getBuyersItemIdentification()
    {
        return $this->BuyersItemIdentification;
    }

    /**
     * Set BuyersItemIdentification value
     * @param ItemIdentificationType $buyersItemIdentification
     * @return ItemType
     */
    public function setBuyersItemIdentification(ItemIdentificationType $buyersItemIdentification = null)
    {
        $this->BuyersItemIdentification = $buyersItemIdentification;
        return $this;
    }

    /**
     * Get SellersItemIdentification value
     * @return ItemIdentificationType|null
     */
    public function getSellersItemIdentification()
    {
        return $this->SellersItemIdentification;
    }

    /**
     * Set SellersItemIdentification value
     * @param ItemIdentificationType $sellersItemIdentification
     * @return ItemType
     */
    public function setSellersItemIdentification(ItemIdentificationType $sellersItemIdentification = null)
    {
        $this->SellersItemIdentification = $sellersItemIdentification;
        return $this;
    }

    /**
     * Get ManufacturersItemIdentification value
     * @return ItemIdentificationType|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }

    /**
     * Set ManufacturersItemIdentification value
     * @param ItemIdentificationType $manufacturersItemIdentification
     * @return ItemType
     */
    public function setManufacturersItemIdentification(ItemIdentificationType $manufacturersItemIdentification = null)
    {
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }

    /**
     * Get AdditionalItemIdentification value
     * @return ItemIdentificationType[]|null
     */
    public function getAdditionalItemIdentification()
    {
        return $this->AdditionalItemIdentification;
    }

    /**
     * This method is responsible for validating the values passed to the setAdditionalItemIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeAdditionalItemIdentificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeAdditionalItemIdentificationItem instanceof ItemIdentificationType) {
                $invalidValues[] = is_object($itemTypeAdditionalItemIdentificationItem) ? get_class($itemTypeAdditionalItemIdentificationItem) : sprintf('%s(%s)', gettype($itemTypeAdditionalItemIdentificationItem), var_export($itemTypeAdditionalItemIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemIdentification property can only contain items of type \Gek\UyumBahce\StructType\ItemIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set AdditionalItemIdentification value
     * @param ItemIdentificationType[] $additionalItemIdentification
     * @return ItemType
     * @throws InvalidArgumentException
     */
    public function setAdditionalItemIdentification(array $additionalItemIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemIdentificationArrayErrorMessage = self::validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification($additionalItemIdentification))) {
            throw new InvalidArgumentException($additionalItemIdentificationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemIdentification = $additionalItemIdentification;
        return $this;
    }

    /**
     * Add item to AdditionalItemIdentification value
     * @param ItemIdentificationType $item
     * @return ItemType
     * @throws InvalidArgumentException
     */
    public function addToAdditionalItemIdentification(ItemIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemIdentificationType) {
            throw new InvalidArgumentException(sprintf('The AdditionalItemIdentification property can only contain items of type \Gek\UyumBahce\StructType\ItemIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemIdentification[] = $item;
        return $this;
    }

    /**
     * Get OriginCountry value
     * @return CountryType|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }

    /**
     * Set OriginCountry value
     * @param CountryType $originCountry
     * @return ItemType
     */
    public function setOriginCountry(CountryType $originCountry = null)
    {
        $this->OriginCountry = $originCountry;
        return $this;
    }

    /**
     * Get CommodityClassification value
     * @return CommodityClassificationType[]|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }

    /**
     * This method is responsible for validating the values passed to the setCommodityClassification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodityClassification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeCommodityClassificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeCommodityClassificationItem instanceof CommodityClassificationType) {
                $invalidValues[] = is_object($itemTypeCommodityClassificationItem) ? get_class($itemTypeCommodityClassificationItem) : sprintf('%s(%s)', gettype($itemTypeCommodityClassificationItem), var_export($itemTypeCommodityClassificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommodityClassification property can only contain items of type \Gek\UyumBahce\StructType\CommodityClassificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set CommodityClassification value
     * @param CommodityClassificationType[] $commodityClassification
     * @return ItemType
     * @throws InvalidArgumentException
     */
    public function setCommodityClassification(array $commodityClassification = array())
    {
        // validation for constraint: array
        if ('' !== ($commodityClassificationArrayErrorMessage = self::validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification($commodityClassification))) {
            throw new InvalidArgumentException($commodityClassificationArrayErrorMessage, __LINE__);
        }
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }

    /**
     * Add item to CommodityClassification value
     * @param CommodityClassificationType $item
     * @return ItemType
     * @throws InvalidArgumentException
     */
    public function addToCommodityClassification(CommodityClassificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CommodityClassificationType) {
            throw new InvalidArgumentException(sprintf('The CommodityClassification property can only contain items of type \Gek\UyumBahce\StructType\CommodityClassificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommodityClassification[] = $item;
        return $this;
    }

    /**
     * Get ItemInstance value
     * @return ItemInstanceType[]|null
     */
    public function getItemInstance()
    {
        return $this->ItemInstance;
    }

    /**
     * This method is responsible for validating the values passed to the setItemInstance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemInstance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemInstanceForArrayConstraintsFromSetItemInstance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeItemInstanceItem) {
            // validation for constraint: itemType
            if (!$itemTypeItemInstanceItem instanceof ItemInstanceType) {
                $invalidValues[] = is_object($itemTypeItemInstanceItem) ? get_class($itemTypeItemInstanceItem) : sprintf('%s(%s)', gettype($itemTypeItemInstanceItem), var_export($itemTypeItemInstanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemInstance property can only contain items of type \Gek\UyumBahce\StructType\ItemInstanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ItemInstance value
     * @param ItemInstanceType[] $itemInstance
     * @return ItemType
     * @throws InvalidArgumentException
     */
    public function setItemInstance(array $itemInstance = array())
    {
        // validation for constraint: array
        if ('' !== ($itemInstanceArrayErrorMessage = self::validateItemInstanceForArrayConstraintsFromSetItemInstance($itemInstance))) {
            throw new InvalidArgumentException($itemInstanceArrayErrorMessage, __LINE__);
        }
        $this->ItemInstance = $itemInstance;
        return $this;
    }

    /**
     * Add item to ItemInstance value
     * @param ItemInstanceType $item
     * @return ItemType
     * @throws InvalidArgumentException
     */
    public function addToItemInstance(ItemInstanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemInstanceType) {
            throw new InvalidArgumentException(sprintf('The ItemInstance property can only contain items of type \Gek\UyumBahce\StructType\ItemInstanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemInstance[] = $item;
        return $this;
    }
}
