<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\AbtOperation;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;

/**
 * This class stands for FinanceDetailDef StructType
 * @subpackage Structs
 */
class FinanceDetailDef extends DetailFields
{
    /**
     * The TraTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TraTypeId;
    /**
     * The FinDCardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FinDCardId;
    /**
     * The Amt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amt;
    /**
     * The AmtTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtTra;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The AbtBudgetId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbtBudgetId;
    /**
     * The SalesPersonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SalesPersonId;
    /**
     * The AbtOperation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AbtOperation;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreateUserId;
    /**
     * The FormContractMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FormContractMId;
    /**
     * The TraTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TraTypeCode;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The DocNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocNo;
    /**
     * The EntityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EntityDef
     */
    public $EntityInfo;
    /**
     * The CardIntgCodePrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardIntgCodePrefix;
    /**
     * The AbtBudgetCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AbtBudgetCode;
    /**
     * The AbtActCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AbtActCode;
    /**
     * The SalesPersonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesPersonCode;
    /**
     * The FormContractCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormContractCode;

    /**
     * Constructor method for FinanceDetailDef
     * @param int $traTypeId
     * @param int $finDCardId
     * @param float $amt
     * @param float $amtTra
     * @param string|GekDateTime $dueDate
     * @param int $abtBudgetId
     * @param int $salesPersonId
     * @param string $abtOperation
     * @param int $createUserId
     * @param int $formContractMId
     * @param string $traTypeCode
     * @param string $cardCode
     * @param string $docNo
     * @param EntityDef $entityInfo
     * @param string $cardIntgCodePrefix
     * @param string $abtBudgetCode
     * @param string $abtActCode
     * @param string $salesPersonCode
     * @param string $formContractCode
     * @uses FinanceDetailDef::setTraTypeId()
     * @uses FinanceDetailDef::setFinDCardId()
     * @uses FinanceDetailDef::setAmt()
     * @uses FinanceDetailDef::setAmtTra()
     * @uses FinanceDetailDef::setDueDate()
     * @uses FinanceDetailDef::setAbtBudgetId()
     * @uses FinanceDetailDef::setSalesPersonId()
     * @uses FinanceDetailDef::setAbtOperation()
     * @uses FinanceDetailDef::setCreateUserId()
     * @uses FinanceDetailDef::setFormContractMId()
     * @uses FinanceDetailDef::setTraTypeCode()
     * @uses FinanceDetailDef::setCardCode()
     * @uses FinanceDetailDef::setDocNo()
     * @uses FinanceDetailDef::setEntityInfo()
     * @uses FinanceDetailDef::setCardIntgCodePrefix()
     * @uses FinanceDetailDef::setAbtBudgetCode()
     * @uses FinanceDetailDef::setAbtActCode()
     * @uses FinanceDetailDef::setSalesPersonCode()
     * @uses FinanceDetailDef::setFormContractCode()
     */
    public function __construct($traTypeId = null, $finDCardId = null, $amt = null, $amtTra = null, $dueDate = null, $abtBudgetId = null, $salesPersonId = null, $abtOperation = null, $createUserId = null, $formContractMId = null, $traTypeCode = null, $cardCode = null, $docNo = null, EntityDef $entityInfo = null, $cardIntgCodePrefix = null, $abtBudgetCode = null, $abtActCode = null, $salesPersonCode = null, $formContractCode = null)
    {
        $this
            ->setTraTypeId($traTypeId)
            ->setFinDCardId($finDCardId)
            ->setAmt($amt)
            ->setAmtTra($amtTra)
            ->setDueDate($dueDate)
            ->setAbtBudgetId($abtBudgetId)
            ->setSalesPersonId($salesPersonId)
            ->setAbtOperation($abtOperation)
            ->setCreateUserId($createUserId)
            ->setFormContractMId($formContractMId)
            ->setTraTypeCode($traTypeCode)
            ->setCardCode($cardCode)
            ->setDocNo($docNo)
            ->setEntityInfo($entityInfo)
            ->setCardIntgCodePrefix($cardIntgCodePrefix)
            ->setAbtBudgetCode($abtBudgetCode)
            ->setAbtActCode($abtActCode)
            ->setSalesPersonCode($salesPersonCode)
            ->setFormContractCode($formContractCode);
    }

    /**
     * Get TraTypeId value
     * @return int
     */
    public function getTraTypeId()
    {
        return $this->TraTypeId;
    }

    /**
     * Set TraTypeId value
     * @param int $traTypeId
     * @return FinanceDetailDef
     */
    public function setTraTypeId($traTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($traTypeId) && !(is_int($traTypeId) || ctype_digit($traTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($traTypeId, true), gettype($traTypeId)), __LINE__);
        }
        $this->TraTypeId = $traTypeId;
        return $this;
    }

    /**
     * Get FinDCardId value
     * @return int
     */
    public function getFinDCardId()
    {
        return $this->FinDCardId;
    }

    /**
     * Set FinDCardId value
     * @param int $finDCardId
     * @return FinanceDetailDef
     */
    public function setFinDCardId($finDCardId = null)
    {
        // validation for constraint: int
        if (!is_null($finDCardId) && !(is_int($finDCardId) || ctype_digit($finDCardId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($finDCardId, true), gettype($finDCardId)), __LINE__);
        }
        $this->FinDCardId = $finDCardId;
        return $this;
    }

    /**
     * Get Amt value
     * @return float
     */
    public function getAmt()
    {
        return $this->Amt;
    }

    /**
     * Set Amt value
     * @param float $amt
     * @return FinanceDetailDef
     */
    public function setAmt($amt = null)
    {
        // validation for constraint: float
        if (!is_null($amt) && !(is_float($amt) || is_numeric($amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amt, true), gettype($amt)), __LINE__);
        }
        $this->Amt = $amt;
        return $this;
    }

    /**
     * Get AmtTra value
     * @return float
     */
    public function getAmtTra()
    {
        return $this->AmtTra;
    }

    /**
     * Set AmtTra value
     * @param float $amtTra
     * @return FinanceDetailDef
     */
    public function setAmtTra($amtTra = null)
    {
        // validation for constraint: float
        if (!is_null($amtTra) && !(is_float($amtTra) || is_numeric($amtTra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtTra, true), gettype($amtTra)), __LINE__);
        }
        $this->AmtTra = $amtTra;
        return $this;
    }

    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }

    /**
     * Set DueDate value
     * @param string|GekDateTime $dueDate
     * @return FinanceDetailDef
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate) && !($dueDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if ($dueDate instanceof GekDateTime) {
            $dueDate = $dueDate->toServiceString();
        }
        $this->DueDate = $dueDate;
        return $this;
    }

    /**
     * Get AbtBudgetId value
     * @return int
     */
    public function getAbtBudgetId()
    {
        return $this->AbtBudgetId;
    }

    /**
     * Set AbtBudgetId value
     * @param int $abtBudgetId
     * @return FinanceDetailDef
     */
    public function setAbtBudgetId($abtBudgetId = null)
    {
        // validation for constraint: int
        if (!is_null($abtBudgetId) && !(is_int($abtBudgetId) || ctype_digit($abtBudgetId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abtBudgetId, true), gettype($abtBudgetId)), __LINE__);
        }
        $this->AbtBudgetId = $abtBudgetId;
        return $this;
    }

    /**
     * Get SalesPersonId value
     * @return int
     */
    public function getSalesPersonId()
    {
        return $this->SalesPersonId;
    }

    /**
     * Set SalesPersonId value
     * @param int $salesPersonId
     * @return FinanceDetailDef
     */
    public function setSalesPersonId($salesPersonId = null)
    {
        // validation for constraint: int
        if (!is_null($salesPersonId) && !(is_int($salesPersonId) || ctype_digit($salesPersonId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesPersonId, true), gettype($salesPersonId)), __LINE__);
        }
        $this->SalesPersonId = $salesPersonId;
        return $this;
    }

    /**
     * Get AbtOperation value
     * @return string
     */
    public function getAbtOperation()
    {
        return $this->AbtOperation;
    }

    /**
     * Set AbtOperation value
     * @param string $abtOperation
     * @return FinanceDetailDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\AbtOperation::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\AbtOperation::valueIsValid()
     */
    public function setAbtOperation($abtOperation = null)
    {
        // validation for constraint: enumeration
        if (!AbtOperation::valueIsValid($abtOperation)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\AbtOperation', is_array($abtOperation) ? implode(', ', $abtOperation) : var_export($abtOperation, true), implode(', ', AbtOperation::getValidValues())), __LINE__);
        }
        $this->AbtOperation = $abtOperation;
        return $this;
    }

    /**
     * Get CreateUserId value
     * @return int
     */
    public function getCreateUserId()
    {
        return $this->CreateUserId;
    }

    /**
     * Set CreateUserId value
     * @param int $createUserId
     * @return FinanceDetailDef
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: int
        if (!is_null($createUserId) && !(is_int($createUserId) || ctype_digit($createUserId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        $this->CreateUserId = $createUserId;
        return $this;
    }

    /**
     * Get FormContractMId value
     * @return int
     */
    public function getFormContractMId()
    {
        return $this->FormContractMId;
    }

    /**
     * Set FormContractMId value
     * @param int $formContractMId
     * @return FinanceDetailDef
     */
    public function setFormContractMId($formContractMId = null)
    {
        // validation for constraint: int
        if (!is_null($formContractMId) && !(is_int($formContractMId) || ctype_digit($formContractMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formContractMId, true), gettype($formContractMId)), __LINE__);
        }
        $this->FormContractMId = $formContractMId;
        return $this;
    }

    /**
     * Get TraTypeCode value
     * @return string|null
     */
    public function getTraTypeCode()
    {
        return $this->TraTypeCode;
    }

    /**
     * Set TraTypeCode value
     * @param string $traTypeCode
     * @return FinanceDetailDef
     */
    public function setTraTypeCode($traTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($traTypeCode) && !is_string($traTypeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traTypeCode, true), gettype($traTypeCode)), __LINE__);
        }
        $this->TraTypeCode = $traTypeCode;
        return $this;
    }

    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }

    /**
     * Set CardCode value
     * @param string $cardCode
     * @return FinanceDetailDef
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }

    /**
     * Get DocNo value
     * @return string|null
     */
    public function getDocNo()
    {
        return $this->DocNo;
    }

    /**
     * Set DocNo value
     * @param string $docNo
     * @return FinanceDetailDef
     */
    public function setDocNo($docNo = null)
    {
        // validation for constraint: string
        if (!is_null($docNo) && !is_string($docNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNo, true), gettype($docNo)), __LINE__);
        }
        $this->DocNo = $docNo;
        return $this;
    }

    /**
     * Get EntityInfo value
     * @return EntityDef|null
     */
    public function getEntityInfo()
    {
        return $this->EntityInfo;
    }

    /**
     * Set EntityInfo value
     * @param EntityDef $entityInfo
     * @return FinanceDetailDef
     */
    public function setEntityInfo(EntityDef $entityInfo = null)
    {
        $this->EntityInfo = $entityInfo;
        return $this;
    }

    /**
     * Get CardIntgCodePrefix value
     * @return string|null
     */
    public function getCardIntgCodePrefix()
    {
        return $this->CardIntgCodePrefix;
    }

    /**
     * Set CardIntgCodePrefix value
     * @param string $cardIntgCodePrefix
     * @return FinanceDetailDef
     */
    public function setCardIntgCodePrefix($cardIntgCodePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($cardIntgCodePrefix) && !is_string($cardIntgCodePrefix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIntgCodePrefix, true), gettype($cardIntgCodePrefix)), __LINE__);
        }
        $this->CardIntgCodePrefix = $cardIntgCodePrefix;
        return $this;
    }

    /**
     * Get AbtBudgetCode value
     * @return string|null
     */
    public function getAbtBudgetCode()
    {
        return $this->AbtBudgetCode;
    }

    /**
     * Set AbtBudgetCode value
     * @param string $abtBudgetCode
     * @return FinanceDetailDef
     */
    public function setAbtBudgetCode($abtBudgetCode = null)
    {
        // validation for constraint: string
        if (!is_null($abtBudgetCode) && !is_string($abtBudgetCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abtBudgetCode, true), gettype($abtBudgetCode)), __LINE__);
        }
        $this->AbtBudgetCode = $abtBudgetCode;
        return $this;
    }

    /**
     * Get AbtActCode value
     * @return string|null
     */
    public function getAbtActCode()
    {
        return $this->AbtActCode;
    }

    /**
     * Set AbtActCode value
     * @param string $abtActCode
     * @return FinanceDetailDef
     */
    public function setAbtActCode($abtActCode = null)
    {
        // validation for constraint: string
        if (!is_null($abtActCode) && !is_string($abtActCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abtActCode, true), gettype($abtActCode)), __LINE__);
        }
        $this->AbtActCode = $abtActCode;
        return $this;
    }

    /**
     * Get SalesPersonCode value
     * @return string|null
     */
    public function getSalesPersonCode()
    {
        return $this->SalesPersonCode;
    }

    /**
     * Set SalesPersonCode value
     * @param string $salesPersonCode
     * @return FinanceDetailDef
     */
    public function setSalesPersonCode($salesPersonCode = null)
    {
        // validation for constraint: string
        if (!is_null($salesPersonCode) && !is_string($salesPersonCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPersonCode, true), gettype($salesPersonCode)), __LINE__);
        }
        $this->SalesPersonCode = $salesPersonCode;
        return $this;
    }

    /**
     * Get FormContractCode value
     * @return string|null
     */
    public function getFormContractCode()
    {
        return $this->FormContractCode;
    }

    /**
     * Set FormContractCode value
     * @param string $formContractCode
     * @return FinanceDetailDef
     */
    public function setFormContractCode($formContractCode = null)
    {
        // validation for constraint: string
        if (!is_null($formContractCode) && !is_string($formContractCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formContractCode, true), gettype($formContractCode)), __LINE__);
        }
        $this->FormContractCode = $formContractCode;
        return $this;
    }
}
