<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfFinanceDetailDef;
use InvalidArgumentException;

/**
 * This class stands for FinanceDef StructType
 * @subpackage Structs
 */
class FinanceDef extends MasterFields
{
    /**
     * The ReceiptTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReceiptTypeId;
    /**
     * The AmtCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtCredit;
    /**
     * The AmtDebit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtDebit;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CardId;
    /**
     * The UseCardIntgId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseCardIntgId;
    /**
     * The ReceiptTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptTypeCode;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfFinanceDetailDef
     */
    public $Details;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The CardName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardName;
    /**
     * The EntityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EntityDef
     */
    public $EntityInfo;

    /**
     * Constructor method for FinanceDef
     * @param int $receiptTypeId
     * @param float $amtCredit
     * @param float $amtDebit
     * @param int $cardId
     * @param bool $useCardIntgId
     * @param string $receiptTypeCode
     * @param ArrayOfFinanceDetailDef $details
     * @param string $cardCode
     * @param string $cardName
     * @param EntityDef $entityInfo
     * @uses FinanceDef::setReceiptTypeId()
     * @uses FinanceDef::setAmtCredit()
     * @uses FinanceDef::setAmtDebit()
     * @uses FinanceDef::setCardId()
     * @uses FinanceDef::setUseCardIntgId()
     * @uses FinanceDef::setReceiptTypeCode()
     * @uses FinanceDef::setDetails()
     * @uses FinanceDef::setCardCode()
     * @uses FinanceDef::setCardName()
     * @uses FinanceDef::setEntityInfo()
     */
    public function __construct($receiptTypeId = null, $amtCredit = null, $amtDebit = null, $cardId = null, $useCardIntgId = null, $receiptTypeCode = null, ArrayOfFinanceDetailDef $details = null, $cardCode = null, $cardName = null, EntityDef $entityInfo = null)
    {
        parent::__construct();
        $this
            ->setReceiptTypeId($receiptTypeId)
            ->setAmtCredit($amtCredit)
            ->setAmtDebit($amtDebit)
            ->setCardId($cardId)
            ->setUseCardIntgId($useCardIntgId)
            ->setReceiptTypeCode($receiptTypeCode)
            ->setDetails($details)
            ->setCardCode($cardCode)
            ->setCardName($cardName)
            ->setEntityInfo($entityInfo);
    }

    /**
     * Get ReceiptTypeId value
     * @return int
     */
    public function getReceiptTypeId()
    {
        return $this->ReceiptTypeId;
    }

    /**
     * Set ReceiptTypeId value
     * @param int $receiptTypeId
     * @return FinanceDef
     */
    public function setReceiptTypeId($receiptTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($receiptTypeId) && !(is_int($receiptTypeId) || ctype_digit($receiptTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptTypeId, true), gettype($receiptTypeId)), __LINE__);
        }
        $this->ReceiptTypeId = $receiptTypeId;
        return $this;
    }

    /**
     * Get AmtCredit value
     * @return float
     */
    public function getAmtCredit()
    {
        return $this->AmtCredit;
    }

    /**
     * Set AmtCredit value
     * @param float $amtCredit
     * @return FinanceDef
     */
    public function setAmtCredit($amtCredit = null)
    {
        // validation for constraint: float
        if (!is_null($amtCredit) && !(is_float($amtCredit) || is_numeric($amtCredit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtCredit, true), gettype($amtCredit)), __LINE__);
        }
        $this->AmtCredit = $amtCredit;
        return $this;
    }

    /**
     * Get AmtDebit value
     * @return float
     */
    public function getAmtDebit()
    {
        return $this->AmtDebit;
    }

    /**
     * Set AmtDebit value
     * @param float $amtDebit
     * @return FinanceDef
     */
    public function setAmtDebit($amtDebit = null)
    {
        // validation for constraint: float
        if (!is_null($amtDebit) && !(is_float($amtDebit) || is_numeric($amtDebit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDebit, true), gettype($amtDebit)), __LINE__);
        }
        $this->AmtDebit = $amtDebit;
        return $this;
    }

    /**
     * Get CardId value
     * @return int
     */
    public function getCardId()
    {
        return $this->CardId;
    }

    /**
     * Set CardId value
     * @param int $cardId
     * @return FinanceDef
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: int
        if (!is_null($cardId) && !(is_int($cardId) || ctype_digit($cardId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }

    /**
     * Get UseCardIntgId value
     * @return bool
     */
    public function getUseCardIntgId()
    {
        return $this->UseCardIntgId;
    }

    /**
     * Set UseCardIntgId value
     * @param bool $useCardIntgId
     * @return FinanceDef
     */
    public function setUseCardIntgId($useCardIntgId = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCardIntgId) && !is_bool($useCardIntgId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useCardIntgId, true), gettype($useCardIntgId)), __LINE__);
        }
        $this->UseCardIntgId = $useCardIntgId;
        return $this;
    }

    /**
     * Get ReceiptTypeCode value
     * @return string|null
     */
    public function getReceiptTypeCode()
    {
        return $this->ReceiptTypeCode;
    }

    /**
     * Set ReceiptTypeCode value
     * @param string $receiptTypeCode
     * @return FinanceDef
     */
    public function setReceiptTypeCode($receiptTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($receiptTypeCode) && !is_string($receiptTypeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptTypeCode, true), gettype($receiptTypeCode)), __LINE__);
        }
        $this->ReceiptTypeCode = $receiptTypeCode;
        return $this;
    }

    /**
     * Get Details value
     * @return ArrayOfFinanceDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfFinanceDetailDef $details
     * @return FinanceDef
     */
    public function setDetails(ArrayOfFinanceDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }

    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }

    /**
     * Set CardCode value
     * @param string $cardCode
     * @return FinanceDef
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }

    /**
     * Get CardName value
     * @return string|null
     */
    public function getCardName()
    {
        return $this->CardName;
    }

    /**
     * Set CardName value
     * @param string $cardName
     * @return FinanceDef
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardName, true), gettype($cardName)), __LINE__);
        }
        $this->CardName = $cardName;
        return $this;
    }

    /**
     * Get EntityInfo value
     * @return EntityDef|null
     */
    public function getEntityInfo()
    {
        return $this->EntityInfo;
    }

    /**
     * Set EntityInfo value
     * @param EntityDef $entityInfo
     * @return FinanceDef
     */
    public function setEntityInfo(EntityDef $entityInfo = null)
    {
        $this->EntityInfo = $entityInfo;
        return $this;
    }
}
