<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\InvoiceDeliveryType;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveInvoiceInformation StructType
 * @subpackage Structs
 */
class EArchiveInvoiceInformation extends AbstractStructBase
{
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DeliveryType;
    /**
     * The NewGenerationPamentRecorderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NewGenerationPaymentRecorderInformation
     */
    public $NewGenerationPamentRecorderInfo;
    /**
     * The InternetSalesInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var InternetSalesInformation
     */
    public $InternetSalesInfo;
    /**
     * The WithHoldings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var EArchiveWithHoldingInformation[]
     */
    public $WithHoldings;

    /**
     * Constructor method for EArchiveInvoiceInformation
     * @param string $deliveryType
     * @param NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @param InternetSalesInformation $internetSalesInfo
     * @param EArchiveWithHoldingInformation[] $withHoldings
     * @uses EArchiveInvoiceInformation::setDeliveryType()
     * @uses EArchiveInvoiceInformation::setNewGenerationPamentRecorderInfo()
     * @uses EArchiveInvoiceInformation::setInternetSalesInfo()
     * @uses EArchiveInvoiceInformation::setWithHoldings()
     */
    public function __construct($deliveryType = null, NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null, InternetSalesInformation $internetSalesInfo = null, array $withHoldings = array())
    {
        $this
            ->setDeliveryType($deliveryType)
            ->setNewGenerationPamentRecorderInfo($newGenerationPamentRecorderInfo)
            ->setInternetSalesInfo($internetSalesInfo)
            ->setWithHoldings($withHoldings);
    }

    /**
     * Get DeliveryType value
     * @return string
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }

    /**
     * Set DeliveryType value
     * @param string $deliveryType
     * @return EArchiveInvoiceInformation
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\InvoiceDeliveryType::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\InvoiceDeliveryType::valueIsValid()
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceDeliveryType::valueIsValid($deliveryType)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\InvoiceDeliveryType', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', InvoiceDeliveryType::getValidValues())), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }

    /**
     * Get NewGenerationPamentRecorderInfo value
     * @return NewGenerationPaymentRecorderInformation|null
     */
    public function getNewGenerationPamentRecorderInfo()
    {
        return $this->NewGenerationPamentRecorderInfo;
    }

    /**
     * Set NewGenerationPamentRecorderInfo value
     * @param NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @return EArchiveInvoiceInformation
     */
    public function setNewGenerationPamentRecorderInfo(NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null)
    {
        $this->NewGenerationPamentRecorderInfo = $newGenerationPamentRecorderInfo;
        return $this;
    }

    /**
     * Get InternetSalesInfo value
     * @return InternetSalesInformation|null
     */
    public function getInternetSalesInfo()
    {
        return $this->InternetSalesInfo;
    }

    /**
     * Set InternetSalesInfo value
     * @param InternetSalesInformation $internetSalesInfo
     * @return EArchiveInvoiceInformation
     */
    public function setInternetSalesInfo(InternetSalesInformation $internetSalesInfo = null)
    {
        $this->InternetSalesInfo = $internetSalesInfo;
        return $this;
    }

    /**
     * Get WithHoldings value
     * @return EArchiveWithHoldingInformation[]|null
     */
    public function getWithHoldings()
    {
        return $this->WithHoldings;
    }

    /**
     * This method is responsible for validating the values passed to the setWithHoldings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithHoldings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithHoldingsForArrayConstraintsFromSetWithHoldings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eArchiveInvoiceInformationWithHoldingsItem) {
            // validation for constraint: itemType
            if (!$eArchiveInvoiceInformationWithHoldingsItem instanceof EArchiveWithHoldingInformation) {
                $invalidValues[] = is_object($eArchiveInvoiceInformationWithHoldingsItem) ? get_class($eArchiveInvoiceInformationWithHoldingsItem) : sprintf('%s(%s)', gettype($eArchiveInvoiceInformationWithHoldingsItem), var_export($eArchiveInvoiceInformationWithHoldingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithHoldings property can only contain items of type \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set WithHoldings value
     * @param EArchiveWithHoldingInformation[] $withHoldings
     * @return EArchiveInvoiceInformation
     * @throws InvalidArgumentException
     */
    public function setWithHoldings(array $withHoldings = array())
    {
        // validation for constraint: array
        if ('' !== ($withHoldingsArrayErrorMessage = self::validateWithHoldingsForArrayConstraintsFromSetWithHoldings($withHoldings))) {
            throw new InvalidArgumentException($withHoldingsArrayErrorMessage, __LINE__);
        }
        $this->WithHoldings = $withHoldings;
        return $this;
    }

    /**
     * Add item to WithHoldings value
     * @param EArchiveWithHoldingInformation $item
     * @return EArchiveInvoiceInformation
     * @throws InvalidArgumentException
     */
    public function addToWithHoldings(EArchiveWithHoldingInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof EArchiveWithHoldingInformation) {
            throw new InvalidArgumentException(sprintf('The WithHoldings property can only contain items of type \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithHoldings[] = $item;
        return $this;
    }
}
