<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentReferenceType StructType
 * @subpackage Structs
 */
class DocumentReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueDate
     * @var IssueDateType
     */
    public $IssueDate;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DocumentTypeCode
     * @var DocumentTypeCodeType
     */
    public $DocumentTypeCode;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DocumentType
     * @var DocumentTypeType
     */
    public $DocumentType;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:DocumentDescription
     * @var DocumentDescriptionType[]
     */
    public $DocumentDescription;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AttachmentType
     */
    public $Attachment;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PeriodType
     */
    public $ValidityPeriod;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $IssuerParty;

    /**
     * Constructor method for DocumentReferenceType
     * @param IDType $iD
     * @param IssueDateType $issueDate
     * @param DocumentTypeCodeType $documentTypeCode
     * @param DocumentTypeType $documentType
     * @param DocumentDescriptionType[] $documentDescription
     * @param AttachmentType $attachment
     * @param PeriodType $validityPeriod
     * @param PartyType $issuerParty
     * @uses DocumentReferenceType::setID()
     * @uses DocumentReferenceType::setIssueDate()
     * @uses DocumentReferenceType::setDocumentTypeCode()
     * @uses DocumentReferenceType::setDocumentType()
     * @uses DocumentReferenceType::setDocumentDescription()
     * @uses DocumentReferenceType::setAttachment()
     * @uses DocumentReferenceType::setValidityPeriod()
     * @uses DocumentReferenceType::setIssuerParty()
     */
    public function __construct(IDType $iD = null, IssueDateType $issueDate = null, DocumentTypeCodeType $documentTypeCode = null, DocumentTypeType $documentType = null, array $documentDescription = array(), AttachmentType $attachment = null, PeriodType $validityPeriod = null, PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setDocumentTypeCode($documentTypeCode)
            ->setDocumentType($documentType)
            ->setDocumentDescription($documentDescription)
            ->setAttachment($attachment)
            ->setValidityPeriod($validityPeriod)
            ->setIssuerParty($issuerParty);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return DocumentReferenceType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get IssueDate value
     * @return IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }

    /**
     * Set IssueDate value
     * @param IssueDateType $issueDate
     * @return DocumentReferenceType
     */
    public function setIssueDate(IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }

    /**
     * Get DocumentTypeCode value
     * @return DocumentTypeCodeType|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }

    /**
     * Set DocumentTypeCode value
     * @param DocumentTypeCodeType $documentTypeCode
     * @return DocumentReferenceType
     */
    public function setDocumentTypeCode(DocumentTypeCodeType $documentTypeCode = null)
    {
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }

    /**
     * Get DocumentType value
     * @return DocumentTypeType|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }

    /**
     * Set DocumentType value
     * @param DocumentTypeType $documentType
     * @return DocumentReferenceType
     */
    public function setDocumentType(DocumentTypeType $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }

    /**
     * Get DocumentDescription value
     * @return DocumentDescriptionType[]|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }

    /**
     * This method is responsible for validating the values passed to the setDocumentDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentReferenceTypeDocumentDescriptionItem) {
            // validation for constraint: itemType
            if (!$documentReferenceTypeDocumentDescriptionItem instanceof DocumentDescriptionType) {
                $invalidValues[] = is_object($documentReferenceTypeDocumentDescriptionItem) ? get_class($documentReferenceTypeDocumentDescriptionItem) : sprintf('%s(%s)', gettype($documentReferenceTypeDocumentDescriptionItem), var_export($documentReferenceTypeDocumentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDescription property can only contain items of type \Gek\UyumBahce\StructType\DocumentDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DocumentDescription value
     * @param DocumentDescriptionType[] $documentDescription
     * @return DocumentReferenceType
     * @throws InvalidArgumentException
     */
    public function setDocumentDescription(array $documentDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDescriptionArrayErrorMessage = self::validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription($documentDescription))) {
            throw new InvalidArgumentException($documentDescriptionArrayErrorMessage, __LINE__);
        }
        $this->DocumentDescription = $documentDescription;
        return $this;
    }

    /**
     * Add item to DocumentDescription value
     * @param DocumentDescriptionType $item
     * @return DocumentReferenceType
     * @throws InvalidArgumentException
     */
    public function addToDocumentDescription(DocumentDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentDescriptionType) {
            throw new InvalidArgumentException(sprintf('The DocumentDescription property can only contain items of type \Gek\UyumBahce\StructType\DocumentDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDescription[] = $item;
        return $this;
    }

    /**
     * Get Attachment value
     * @return AttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }

    /**
     * Set Attachment value
     * @param AttachmentType $attachment
     * @return DocumentReferenceType
     */
    public function setAttachment(AttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }

    /**
     * Get ValidityPeriod value
     * @return PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }

    /**
     * Set ValidityPeriod value
     * @param PeriodType $validityPeriod
     * @return DocumentReferenceType
     */
    public function setValidityPeriod(PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }

    /**
     * Get IssuerParty value
     * @return PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }

    /**
     * Set IssuerParty value
     * @param PartyType $issuerParty
     * @return DocumentReferenceType
     */
    public function setIssuerParty(PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
}
