<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactType StructType
 * @subpackage Structs
 */
class ContactType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var NameType
     */
    public $Name;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Telephone
     * @var TelephoneType
     */
    public $Telephone;
    /**
     * The Telefax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Telefax
     * @var TelefaxType
     */
    public $Telefax;
    /**
     * The ElectronicMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ElectronicMail
     * @var ElectronicMailType
     */
    public $ElectronicMail;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Note
     * @var NoteType
     */
    public $Note;
    /**
     * The OtherCommunication
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var CommunicationType[]
     */
    public $OtherCommunication;

    /**
     * Constructor method for ContactType
     * @param IDType $iD
     * @param NameType $name
     * @param TelephoneType $telephone
     * @param TelefaxType $telefax
     * @param ElectronicMailType $electronicMail
     * @param NoteType $note
     * @param CommunicationType[] $otherCommunication
     * @uses ContactType::setID()
     * @uses ContactType::setName()
     * @uses ContactType::setTelephone()
     * @uses ContactType::setTelefax()
     * @uses ContactType::setElectronicMail()
     * @uses ContactType::setNote()
     * @uses ContactType::setOtherCommunication()
     */
    public function __construct(IDType $iD = null, NameType $name = null, TelephoneType $telephone = null, TelefaxType $telefax = null, ElectronicMailType $electronicMail = null, NoteType $note = null, array $otherCommunication = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setTelephone($telephone)
            ->setTelefax($telefax)
            ->setElectronicMail($electronicMail)
            ->setNote($note)
            ->setOtherCommunication($otherCommunication);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return ContactType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Name value
     * @return NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * Set Name value
     * @param NameType $name
     * @return ContactType
     */
    public function setName(NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }

    /**
     * Get Telephone value
     * @return TelephoneType|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }

    /**
     * Set Telephone value
     * @param TelephoneType $telephone
     * @return ContactType
     */
    public function setTelephone(TelephoneType $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }

    /**
     * Get Telefax value
     * @return TelefaxType|null
     */
    public function getTelefax()
    {
        return $this->Telefax;
    }

    /**
     * Set Telefax value
     * @param TelefaxType $telefax
     * @return ContactType
     */
    public function setTelefax(TelefaxType $telefax = null)
    {
        $this->Telefax = $telefax;
        return $this;
    }

    /**
     * Get ElectronicMail value
     * @return ElectronicMailType|null
     */
    public function getElectronicMail()
    {
        return $this->ElectronicMail;
    }

    /**
     * Set ElectronicMail value
     * @param ElectronicMailType $electronicMail
     * @return ContactType
     */
    public function setElectronicMail(ElectronicMailType $electronicMail = null)
    {
        $this->ElectronicMail = $electronicMail;
        return $this;
    }

    /**
     * Get Note value
     * @return NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }

    /**
     * Set Note value
     * @param NoteType $note
     * @return ContactType
     */
    public function setNote(NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }

    /**
     * Get OtherCommunication value
     * @return CommunicationType[]|null
     */
    public function getOtherCommunication()
    {
        return $this->OtherCommunication;
    }

    /**
     * This method is responsible for validating the values passed to the setOtherCommunication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherCommunication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherCommunicationForArrayConstraintsFromSetOtherCommunication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactTypeOtherCommunicationItem) {
            // validation for constraint: itemType
            if (!$contactTypeOtherCommunicationItem instanceof CommunicationType) {
                $invalidValues[] = is_object($contactTypeOtherCommunicationItem) ? get_class($contactTypeOtherCommunicationItem) : sprintf('%s(%s)', gettype($contactTypeOtherCommunicationItem), var_export($contactTypeOtherCommunicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherCommunication property can only contain items of type \Gek\UyumBahce\StructType\CommunicationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OtherCommunication value
     * @param CommunicationType[] $otherCommunication
     * @return ContactType
     * @throws InvalidArgumentException
     */
    public function setOtherCommunication(array $otherCommunication = array())
    {
        // validation for constraint: array
        if ('' !== ($otherCommunicationArrayErrorMessage = self::validateOtherCommunicationForArrayConstraintsFromSetOtherCommunication($otherCommunication))) {
            throw new InvalidArgumentException($otherCommunicationArrayErrorMessage, __LINE__);
        }
        $this->OtherCommunication = $otherCommunication;
        return $this;
    }

    /**
     * Add item to OtherCommunication value
     * @param CommunicationType $item
     * @return ContactType
     * @throws InvalidArgumentException
     */
    public function addToOtherCommunication(CommunicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CommunicationType) {
            throw new InvalidArgumentException(sprintf('The OtherCommunication property can only contain items of type \Gek\UyumBahce\StructType\CommunicationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OtherCommunication[] = $item;
        return $this;
    }
}
