<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccDetailDefMM StructType
 * @subpackage Structs
 */
class AccDetailDefMM extends AbstractStructBase
{
    /**
     * The LineNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LineNo;
    /**
     * The CurTraId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurTraId;
    /**
     * The CurRateTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurRateTypeId;
    /**
     * The CurRateTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurRateTra;
    /**
     * The AmtDebit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDebit;
    /**
     * The AmtCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtCredit;
    /**
     * The AmtTraDebit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtTraDebit;
    /**
     * The AmtTraCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtTraCredit;
    /**
     * The CatCode1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CatCode1Id;
    /**
     * The CatCode2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CatCode2Id;
    /**
     * The SourceMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceMId;
    /**
     * The SourceDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceDId;
    /**
     * The AccId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AccId;
    /**
     * The TraTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TraTypeId;
    /**
     * The EbookPaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EbookPaymentMethod;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DocumentDate;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The IsMatchAccCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsMatchAccCode;
    /**
     * The CurCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurCode;
    /**
     * The CurRateTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurRateTypeCode;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;
    /**
     * The CatCode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatCode1;
    /**
     * The CatCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatCode2;
    /**
     * The AccCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccCode;
    /**
     * The AccDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccDesc;
    /**
     * The TraTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TraTypeCode;
    /**
     * The DocNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocNo;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The TaxNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNo;
    /**
     * The IdentifyNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdentifyNo;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The TownName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TownName;
    /**
     * The TaxOfficeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOfficeCode;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Tel1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tel1;
    /**
     * The MobileTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobileTel;
    /**
     * The DeclarationAdressNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeclarationAdressNo;

    /**
     * Constructor method for AccDetailDefMM
     * @param int $lineNo
     * @param int $curTraId
     * @param int $curRateTypeId
     * @param float $curRateTra
     * @param float $amtDebit
     * @param float $amtCredit
     * @param float $amtTraDebit
     * @param float $amtTraCredit
     * @param int $catCode1Id
     * @param int $catCode2Id
     * @param int $sourceMId
     * @param int $sourceDId
     * @param int $accId
     * @param int $traTypeId
     * @param int $ebookPaymentMethod
     * @param string|GekDateTime $documentDate
     * @param float $qty
     * @param bool $isMatchAccCode
     * @param string $curCode
     * @param string $curRateTypeCode
     * @param string $note1
     * @param string $catCode1
     * @param string $catCode2
     * @param string $accCode
     * @param string $accDesc
     * @param string $traTypeCode
     * @param string $docNo
     * @param string $itemCode
     * @param string $itemName
     * @param string $unitCode
     * @param string $title
     * @param string $taxNo
     * @param string $identifyNo
     * @param string $cityName
     * @param string $townName
     * @param string $taxOfficeCode
     * @param string $address
     * @param string $zipCode
     * @param string $email
     * @param string $fax
     * @param string $tel1
     * @param string $mobileTel
     * @param string $declarationAdressNo
     * @uses AccDetailDefMM::setLineNo()
     * @uses AccDetailDefMM::setCurTraId()
     * @uses AccDetailDefMM::setCurRateTypeId()
     * @uses AccDetailDefMM::setCurRateTra()
     * @uses AccDetailDefMM::setAmtDebit()
     * @uses AccDetailDefMM::setAmtCredit()
     * @uses AccDetailDefMM::setAmtTraDebit()
     * @uses AccDetailDefMM::setAmtTraCredit()
     * @uses AccDetailDefMM::setCatCode1Id()
     * @uses AccDetailDefMM::setCatCode2Id()
     * @uses AccDetailDefMM::setSourceMId()
     * @uses AccDetailDefMM::setSourceDId()
     * @uses AccDetailDefMM::setAccId()
     * @uses AccDetailDefMM::setTraTypeId()
     * @uses AccDetailDefMM::setEbookPaymentMethod()
     * @uses AccDetailDefMM::setDocumentDate()
     * @uses AccDetailDefMM::setQty()
     * @uses AccDetailDefMM::setIsMatchAccCode()
     * @uses AccDetailDefMM::setCurCode()
     * @uses AccDetailDefMM::setCurRateTypeCode()
     * @uses AccDetailDefMM::setNote1()
     * @uses AccDetailDefMM::setCatCode1()
     * @uses AccDetailDefMM::setCatCode2()
     * @uses AccDetailDefMM::setAccCode()
     * @uses AccDetailDefMM::setAccDesc()
     * @uses AccDetailDefMM::setTraTypeCode()
     * @uses AccDetailDefMM::setDocNo()
     * @uses AccDetailDefMM::setItemCode()
     * @uses AccDetailDefMM::setItemName()
     * @uses AccDetailDefMM::setUnitCode()
     * @uses AccDetailDefMM::setTitle()
     * @uses AccDetailDefMM::setTaxNo()
     * @uses AccDetailDefMM::setIdentifyNo()
     * @uses AccDetailDefMM::setCityName()
     * @uses AccDetailDefMM::setTownName()
     * @uses AccDetailDefMM::setTaxOfficeCode()
     * @uses AccDetailDefMM::setAddress()
     * @uses AccDetailDefMM::setZipCode()
     * @uses AccDetailDefMM::setEmail()
     * @uses AccDetailDefMM::setFax()
     * @uses AccDetailDefMM::setTel1()
     * @uses AccDetailDefMM::setMobileTel()
     * @uses AccDetailDefMM::setDeclarationAdressNo()
     */
    public function __construct($lineNo = null, $curTraId = null, $curRateTypeId = null, $curRateTra = null, $amtDebit = null, $amtCredit = null, $amtTraDebit = null, $amtTraCredit = null, $catCode1Id = null, $catCode2Id = null, $sourceMId = null, $sourceDId = null, $accId = null, $traTypeId = null, $ebookPaymentMethod = null, $documentDate = null, $qty = null, $isMatchAccCode = null, $curCode = null, $curRateTypeCode = null, $note1 = null, $catCode1 = null, $catCode2 = null, $accCode = null, $accDesc = null, $traTypeCode = null, $docNo = null, $itemCode = null, $itemName = null, $unitCode = null, $title = null, $taxNo = null, $identifyNo = null, $cityName = null, $townName = null, $taxOfficeCode = null, $address = null, $zipCode = null, $email = null, $fax = null, $tel1 = null, $mobileTel = null, $declarationAdressNo = null)
    {
        $this
            ->setLineNo($lineNo)
            ->setCurTraId($curTraId)
            ->setCurRateTypeId($curRateTypeId)
            ->setCurRateTra($curRateTra)
            ->setAmtDebit($amtDebit)
            ->setAmtCredit($amtCredit)
            ->setAmtTraDebit($amtTraDebit)
            ->setAmtTraCredit($amtTraCredit)
            ->setCatCode1Id($catCode1Id)
            ->setCatCode2Id($catCode2Id)
            ->setSourceMId($sourceMId)
            ->setSourceDId($sourceDId)
            ->setAccId($accId)
            ->setTraTypeId($traTypeId)
            ->setEbookPaymentMethod($ebookPaymentMethod)
            ->setDocumentDate($documentDate)
            ->setQty($qty)
            ->setIsMatchAccCode($isMatchAccCode)
            ->setCurCode($curCode)
            ->setCurRateTypeCode($curRateTypeCode)
            ->setNote1($note1)
            ->setCatCode1($catCode1)
            ->setCatCode2($catCode2)
            ->setAccCode($accCode)
            ->setAccDesc($accDesc)
            ->setTraTypeCode($traTypeCode)
            ->setDocNo($docNo)
            ->setItemCode($itemCode)
            ->setItemName($itemName)
            ->setUnitCode($unitCode)
            ->setTitle($title)
            ->setTaxNo($taxNo)
            ->setIdentifyNo($identifyNo)
            ->setCityName($cityName)
            ->setTownName($townName)
            ->setTaxOfficeCode($taxOfficeCode)
            ->setAddress($address)
            ->setZipCode($zipCode)
            ->setEmail($email)
            ->setFax($fax)
            ->setTel1($tel1)
            ->setMobileTel($mobileTel)
            ->setDeclarationAdressNo($declarationAdressNo);
    }

    /**
     * Get LineNo value
     * @return int
     */
    public function getLineNo()
    {
        return $this->LineNo;
    }

    /**
     * Set LineNo value
     * @param int $lineNo
     * @return AccDetailDefMM
     */
    public function setLineNo($lineNo = null)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !(is_int($lineNo) || ctype_digit($lineNo))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNo, true), gettype($lineNo)), __LINE__);
        }
        $this->LineNo = $lineNo;
        return $this;
    }

    /**
     * Get CurTraId value
     * @return int
     */
    public function getCurTraId()
    {
        return $this->CurTraId;
    }

    /**
     * Set CurTraId value
     * @param int $curTraId
     * @return AccDetailDefMM
     */
    public function setCurTraId($curTraId = null)
    {
        // validation for constraint: int
        if (!is_null($curTraId) && !(is_int($curTraId) || ctype_digit($curTraId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($curTraId, true), gettype($curTraId)), __LINE__);
        }
        $this->CurTraId = $curTraId;
        return $this;
    }

    /**
     * Get CurRateTypeId value
     * @return int
     */
    public function getCurRateTypeId()
    {
        return $this->CurRateTypeId;
    }

    /**
     * Set CurRateTypeId value
     * @param int $curRateTypeId
     * @return AccDetailDefMM
     */
    public function setCurRateTypeId($curRateTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($curRateTypeId) && !(is_int($curRateTypeId) || ctype_digit($curRateTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($curRateTypeId, true), gettype($curRateTypeId)), __LINE__);
        }
        $this->CurRateTypeId = $curRateTypeId;
        return $this;
    }

    /**
     * Get CurRateTra value
     * @return float
     */
    public function getCurRateTra()
    {
        return $this->CurRateTra;
    }

    /**
     * Set CurRateTra value
     * @param float $curRateTra
     * @return AccDetailDefMM
     */
    public function setCurRateTra($curRateTra = null)
    {
        // validation for constraint: float
        if (!is_null($curRateTra) && !(is_float($curRateTra) || is_numeric($curRateTra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($curRateTra, true), gettype($curRateTra)), __LINE__);
        }
        $this->CurRateTra = $curRateTra;
        return $this;
    }

    /**
     * Get AmtDebit value
     * @return float
     */
    public function getAmtDebit()
    {
        return $this->AmtDebit;
    }

    /**
     * Set AmtDebit value
     * @param float $amtDebit
     * @return AccDetailDefMM
     */
    public function setAmtDebit($amtDebit = null)
    {
        // validation for constraint: float
        if (!is_null($amtDebit) && !(is_float($amtDebit) || is_numeric($amtDebit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDebit, true), gettype($amtDebit)), __LINE__);
        }
        $this->AmtDebit = $amtDebit;
        return $this;
    }

    /**
     * Get AmtCredit value
     * @return float
     */
    public function getAmtCredit()
    {
        return $this->AmtCredit;
    }

    /**
     * Set AmtCredit value
     * @param float $amtCredit
     * @return AccDetailDefMM
     */
    public function setAmtCredit($amtCredit = null)
    {
        // validation for constraint: float
        if (!is_null($amtCredit) && !(is_float($amtCredit) || is_numeric($amtCredit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtCredit, true), gettype($amtCredit)), __LINE__);
        }
        $this->AmtCredit = $amtCredit;
        return $this;
    }

    /**
     * Get AmtTraDebit value
     * @return float
     */
    public function getAmtTraDebit()
    {
        return $this->AmtTraDebit;
    }

    /**
     * Set AmtTraDebit value
     * @param float $amtTraDebit
     * @return AccDetailDefMM
     */
    public function setAmtTraDebit($amtTraDebit = null)
    {
        // validation for constraint: float
        if (!is_null($amtTraDebit) && !(is_float($amtTraDebit) || is_numeric($amtTraDebit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtTraDebit, true), gettype($amtTraDebit)), __LINE__);
        }
        $this->AmtTraDebit = $amtTraDebit;
        return $this;
    }

    /**
     * Get AmtTraCredit value
     * @return float
     */
    public function getAmtTraCredit()
    {
        return $this->AmtTraCredit;
    }

    /**
     * Set AmtTraCredit value
     * @param float $amtTraCredit
     * @return AccDetailDefMM
     */
    public function setAmtTraCredit($amtTraCredit = null)
    {
        // validation for constraint: float
        if (!is_null($amtTraCredit) && !(is_float($amtTraCredit) || is_numeric($amtTraCredit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtTraCredit, true), gettype($amtTraCredit)), __LINE__);
        }
        $this->AmtTraCredit = $amtTraCredit;
        return $this;
    }

    /**
     * Get CatCode1Id value
     * @return int
     */
    public function getCatCode1Id()
    {
        return $this->CatCode1Id;
    }

    /**
     * Set CatCode1Id value
     * @param int $catCode1Id
     * @return AccDetailDefMM
     */
    public function setCatCode1Id($catCode1Id = null)
    {
        // validation for constraint: int
        if (!is_null($catCode1Id) && !(is_int($catCode1Id) || ctype_digit($catCode1Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catCode1Id, true), gettype($catCode1Id)), __LINE__);
        }
        $this->CatCode1Id = $catCode1Id;
        return $this;
    }

    /**
     * Get CatCode2Id value
     * @return int
     */
    public function getCatCode2Id()
    {
        return $this->CatCode2Id;
    }

    /**
     * Set CatCode2Id value
     * @param int $catCode2Id
     * @return AccDetailDefMM
     */
    public function setCatCode2Id($catCode2Id = null)
    {
        // validation for constraint: int
        if (!is_null($catCode2Id) && !(is_int($catCode2Id) || ctype_digit($catCode2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catCode2Id, true), gettype($catCode2Id)), __LINE__);
        }
        $this->CatCode2Id = $catCode2Id;
        return $this;
    }

    /**
     * Get SourceMId value
     * @return int
     */
    public function getSourceMId()
    {
        return $this->SourceMId;
    }

    /**
     * Set SourceMId value
     * @param int $sourceMId
     * @return AccDetailDefMM
     */
    public function setSourceMId($sourceMId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceMId) && !(is_int($sourceMId) || ctype_digit($sourceMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceMId, true), gettype($sourceMId)), __LINE__);
        }
        $this->SourceMId = $sourceMId;
        return $this;
    }

    /**
     * Get SourceDId value
     * @return int
     */
    public function getSourceDId()
    {
        return $this->SourceDId;
    }

    /**
     * Set SourceDId value
     * @param int $sourceDId
     * @return AccDetailDefMM
     */
    public function setSourceDId($sourceDId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDId) && !(is_int($sourceDId) || ctype_digit($sourceDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDId, true), gettype($sourceDId)), __LINE__);
        }
        $this->SourceDId = $sourceDId;
        return $this;
    }

    /**
     * Get AccId value
     * @return int
     */
    public function getAccId()
    {
        return $this->AccId;
    }

    /**
     * Set AccId value
     * @param int $accId
     * @return AccDetailDefMM
     */
    public function setAccId($accId = null)
    {
        // validation for constraint: int
        if (!is_null($accId) && !(is_int($accId) || ctype_digit($accId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accId, true), gettype($accId)), __LINE__);
        }
        $this->AccId = $accId;
        return $this;
    }

    /**
     * Get TraTypeId value
     * @return int
     */
    public function getTraTypeId()
    {
        return $this->TraTypeId;
    }

    /**
     * Set TraTypeId value
     * @param int $traTypeId
     * @return AccDetailDefMM
     */
    public function setTraTypeId($traTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($traTypeId) && !(is_int($traTypeId) || ctype_digit($traTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($traTypeId, true), gettype($traTypeId)), __LINE__);
        }
        $this->TraTypeId = $traTypeId;
        return $this;
    }

    /**
     * Get EbookPaymentMethod value
     * @return int
     */
    public function getEbookPaymentMethod()
    {
        return $this->EbookPaymentMethod;
    }

    /**
     * Set EbookPaymentMethod value
     * @param int $ebookPaymentMethod
     * @return AccDetailDefMM
     */
    public function setEbookPaymentMethod($ebookPaymentMethod = null)
    {
        // validation for constraint: int
        if (!is_null($ebookPaymentMethod) && !(is_int($ebookPaymentMethod) || ctype_digit($ebookPaymentMethod))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ebookPaymentMethod, true), gettype($ebookPaymentMethod)), __LINE__);
        }
        $this->EbookPaymentMethod = $ebookPaymentMethod;
        return $this;
    }

    /**
     * Get DocumentDate value
     * @return string
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }

    /**
     * Set DocumentDate value
     * @param string|GekDateTime $documentDate
     * @return AccDetailDefMM
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate) && !($documentDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        if ($documentDate instanceof GekDateTime) {
            $documentDate = $documentDate->toServiceString();
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }

    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }

    /**
     * Set Qty value
     * @param float $qty
     * @return AccDetailDefMM
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }

    /**
     * Get IsMatchAccCode value
     * @return bool
     */
    public function getIsMatchAccCode()
    {
        return $this->IsMatchAccCode;
    }

    /**
     * Set IsMatchAccCode value
     * @param bool $isMatchAccCode
     * @return AccDetailDefMM
     */
    public function setIsMatchAccCode($isMatchAccCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMatchAccCode) && !is_bool($isMatchAccCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMatchAccCode, true), gettype($isMatchAccCode)), __LINE__);
        }
        $this->IsMatchAccCode = $isMatchAccCode;
        return $this;
    }

    /**
     * Get CurCode value
     * @return string|null
     */
    public function getCurCode()
    {
        return $this->CurCode;
    }

    /**
     * Set CurCode value
     * @param string $curCode
     * @return AccDetailDefMM
     */
    public function setCurCode($curCode = null)
    {
        // validation for constraint: string
        if (!is_null($curCode) && !is_string($curCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curCode, true), gettype($curCode)), __LINE__);
        }
        $this->CurCode = $curCode;
        return $this;
    }

    /**
     * Get CurRateTypeCode value
     * @return string|null
     */
    public function getCurRateTypeCode()
    {
        return $this->CurRateTypeCode;
    }

    /**
     * Set CurRateTypeCode value
     * @param string $curRateTypeCode
     * @return AccDetailDefMM
     */
    public function setCurRateTypeCode($curRateTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($curRateTypeCode) && !is_string($curRateTypeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curRateTypeCode, true), gettype($curRateTypeCode)), __LINE__);
        }
        $this->CurRateTypeCode = $curRateTypeCode;
        return $this;
    }

    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }

    /**
     * Set Note1 value
     * @param string $note1
     * @return AccDetailDefMM
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }

    /**
     * Get CatCode1 value
     * @return string|null
     */
    public function getCatCode1()
    {
        return $this->CatCode1;
    }

    /**
     * Set CatCode1 value
     * @param string $catCode1
     * @return AccDetailDefMM
     */
    public function setCatCode1($catCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($catCode1) && !is_string($catCode1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode1, true), gettype($catCode1)), __LINE__);
        }
        $this->CatCode1 = $catCode1;
        return $this;
    }

    /**
     * Get CatCode2 value
     * @return string|null
     */
    public function getCatCode2()
    {
        return $this->CatCode2;
    }

    /**
     * Set CatCode2 value
     * @param string $catCode2
     * @return AccDetailDefMM
     */
    public function setCatCode2($catCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($catCode2) && !is_string($catCode2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode2, true), gettype($catCode2)), __LINE__);
        }
        $this->CatCode2 = $catCode2;
        return $this;
    }

    /**
     * Get AccCode value
     * @return string|null
     */
    public function getAccCode()
    {
        return $this->AccCode;
    }

    /**
     * Set AccCode value
     * @param string $accCode
     * @return AccDetailDefMM
     */
    public function setAccCode($accCode = null)
    {
        // validation for constraint: string
        if (!is_null($accCode) && !is_string($accCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accCode, true), gettype($accCode)), __LINE__);
        }
        $this->AccCode = $accCode;
        return $this;
    }

    /**
     * Get AccDesc value
     * @return string|null
     */
    public function getAccDesc()
    {
        return $this->AccDesc;
    }

    /**
     * Set AccDesc value
     * @param string $accDesc
     * @return AccDetailDefMM
     */
    public function setAccDesc($accDesc = null)
    {
        // validation for constraint: string
        if (!is_null($accDesc) && !is_string($accDesc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accDesc, true), gettype($accDesc)), __LINE__);
        }
        $this->AccDesc = $accDesc;
        return $this;
    }

    /**
     * Get TraTypeCode value
     * @return string|null
     */
    public function getTraTypeCode()
    {
        return $this->TraTypeCode;
    }

    /**
     * Set TraTypeCode value
     * @param string $traTypeCode
     * @return AccDetailDefMM
     */
    public function setTraTypeCode($traTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($traTypeCode) && !is_string($traTypeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traTypeCode, true), gettype($traTypeCode)), __LINE__);
        }
        $this->TraTypeCode = $traTypeCode;
        return $this;
    }

    /**
     * Get DocNo value
     * @return string|null
     */
    public function getDocNo()
    {
        return $this->DocNo;
    }

    /**
     * Set DocNo value
     * @param string $docNo
     * @return AccDetailDefMM
     */
    public function setDocNo($docNo = null)
    {
        // validation for constraint: string
        if (!is_null($docNo) && !is_string($docNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNo, true), gettype($docNo)), __LINE__);
        }
        $this->DocNo = $docNo;
        return $this;
    }

    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }

    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return AccDetailDefMM
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }

    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }

    /**
     * Set ItemName value
     * @param string $itemName
     * @return AccDetailDefMM
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }

    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }

    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return AccDetailDefMM
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }

    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }

    /**
     * Set Title value
     * @param string $title
     * @return AccDetailDefMM
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }

    /**
     * Get TaxNo value
     * @return string|null
     */
    public function getTaxNo()
    {
        return $this->TaxNo;
    }

    /**
     * Set TaxNo value
     * @param string $taxNo
     * @return AccDetailDefMM
     */
    public function setTaxNo($taxNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxNo) && !is_string($taxNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNo, true), gettype($taxNo)), __LINE__);
        }
        $this->TaxNo = $taxNo;
        return $this;
    }

    /**
     * Get IdentifyNo value
     * @return string|null
     */
    public function getIdentifyNo()
    {
        return $this->IdentifyNo;
    }

    /**
     * Set IdentifyNo value
     * @param string $identifyNo
     * @return AccDetailDefMM
     */
    public function setIdentifyNo($identifyNo = null)
    {
        // validation for constraint: string
        if (!is_null($identifyNo) && !is_string($identifyNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifyNo, true), gettype($identifyNo)), __LINE__);
        }
        $this->IdentifyNo = $identifyNo;
        return $this;
    }

    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }

    /**
     * Set CityName value
     * @param string $cityName
     * @return AccDetailDefMM
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }

    /**
     * Get TownName value
     * @return string|null
     */
    public function getTownName()
    {
        return $this->TownName;
    }

    /**
     * Set TownName value
     * @param string $townName
     * @return AccDetailDefMM
     */
    public function setTownName($townName = null)
    {
        // validation for constraint: string
        if (!is_null($townName) && !is_string($townName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($townName, true), gettype($townName)), __LINE__);
        }
        $this->TownName = $townName;
        return $this;
    }

    /**
     * Get TaxOfficeCode value
     * @return string|null
     */
    public function getTaxOfficeCode()
    {
        return $this->TaxOfficeCode;
    }

    /**
     * Set TaxOfficeCode value
     * @param string $taxOfficeCode
     * @return AccDetailDefMM
     */
    public function setTaxOfficeCode($taxOfficeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxOfficeCode) && !is_string($taxOfficeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOfficeCode, true), gettype($taxOfficeCode)), __LINE__);
        }
        $this->TaxOfficeCode = $taxOfficeCode;
        return $this;
    }

    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }

    /**
     * Set Address value
     * @param string $address
     * @return AccDetailDefMM
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }

    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }

    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return AccDetailDefMM
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }

    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }

    /**
     * Set Email value
     * @param string $email
     * @return AccDetailDefMM
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }

    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }

    /**
     * Set Fax value
     * @param string $fax
     * @return AccDetailDefMM
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }

    /**
     * Get Tel1 value
     * @return string|null
     */
    public function getTel1()
    {
        return $this->Tel1;
    }

    /**
     * Set Tel1 value
     * @param string $tel1
     * @return AccDetailDefMM
     */
    public function setTel1($tel1 = null)
    {
        // validation for constraint: string
        if (!is_null($tel1) && !is_string($tel1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tel1, true), gettype($tel1)), __LINE__);
        }
        $this->Tel1 = $tel1;
        return $this;
    }

    /**
     * Get MobileTel value
     * @return string|null
     */
    public function getMobileTel()
    {
        return $this->MobileTel;
    }

    /**
     * Set MobileTel value
     * @param string $mobileTel
     * @return AccDetailDefMM
     */
    public function setMobileTel($mobileTel = null)
    {
        // validation for constraint: string
        if (!is_null($mobileTel) && !is_string($mobileTel)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileTel, true), gettype($mobileTel)), __LINE__);
        }
        $this->MobileTel = $mobileTel;
        return $this;
    }

    /**
     * Get DeclarationAdressNo value
     * @return string|null
     */
    public function getDeclarationAdressNo()
    {
        return $this->DeclarationAdressNo;
    }

    /**
     * Set DeclarationAdressNo value
     * @param string $declarationAdressNo
     * @return AccDetailDefMM
     */
    public function setDeclarationAdressNo($declarationAdressNo = null)
    {
        // validation for constraint: string
        if (!is_null($declarationAdressNo) && !is_string($declarationAdressNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declarationAdressNo, true), gettype($declarationAdressNo)), __LINE__);
        }
        $this->DeclarationAdressNo = $declarationAdressNo;
        return $this;
    }
}
