<?php

namespace Gek\UyumBahce\ServiceType;

use Gek\UyumBahce\StructType\DeleteFinance;
use Gek\UyumBahce\StructType\DeleteFinanceResponse;
use Gek\UyumBahce\StructType\DeleteInvoice;
use Gek\UyumBahce\StructType\DeleteInvoiceResponse;
use Gek\UyumBahce\StructType\DeleteUyumObjectFromXML;
use Gek\UyumBahce\StructType\DeleteUyumObjectFromXMLResponse;
use Gek\UyumBahce\StructType\DeleteWaybill;
use Gek\UyumBahce\StructType\DeleteWaybillResponse;
use SoapFault;
use WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteInvoice
     * Meta information extracted from the WSDL
     * - documentation: Fatura Kaydı Siler.
     * @param DeleteInvoice $parameters
     * @return DeleteInvoiceResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function DeleteInvoice(DeleteInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named DeleteFinance
     * Meta information extracted from the WSDL
     * - documentation: Finans Kaydı Siler.
     * @param DeleteFinance $parameters
     * @return DeleteFinanceResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function DeleteFinance(DeleteFinance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteFinance', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named DeleteWaybill
     * Meta information extracted from the WSDL
     * - documentation: İrsaliye Kaydı Siler.
     * @param DeleteWaybill $parameters
     * @return DeleteWaybillResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function DeleteWaybill(DeleteWaybill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteWaybill', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named DeleteUyumObjectFromXML
     * Meta information extracted from the WSDL
     * - documentation: Tipi belirtilen object nin kaydının silinmesi.
     * @param DeleteUyumObjectFromXML $parameters
     * @return DeleteUyumObjectFromXMLResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function DeleteUyumObjectFromXML(DeleteUyumObjectFromXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteUyumObjectFromXML', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Returns the result
     * @return DeleteFinanceResponse|DeleteInvoiceResponse|DeleteUyumObjectFromXMLResponse|DeleteWaybillResponse
     * @see AbstractSoapClientBase::getResult()
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
