<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\OrderDef;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDef ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDef extends AbstractStructArrayBase
{
    /**
     * The OrderDef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var OrderDef[]
     */
    public $OrderDef;

    /**
     * Constructor method for ArrayOfOrderDef
     * @param OrderDef[] $orderDef
     * @uses ArrayOfOrderDef::setOrderDef()
     */
    public function __construct(array $orderDef = array())
    {
        $this
            ->setOrderDef($orderDef);
    }

    /**
     * Get OrderDef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return OrderDef[]|null
     */
    public function getOrderDef()
    {
        return isset($this->OrderDef) ? $this->OrderDef : null;
    }

    /**
     * This method is responsible for validating the values passed to the setOrderDef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDefForArrayConstraintsFromSetOrderDef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderDefOrderDefItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDefOrderDefItem instanceof OrderDef) {
                $invalidValues[] = is_object($arrayOfOrderDefOrderDefItem) ? get_class($arrayOfOrderDefOrderDefItem) : sprintf('%s(%s)', gettype($arrayOfOrderDefOrderDefItem), var_export($arrayOfOrderDefOrderDefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderDef property can only contain items of type \Gek\UyumBahce\StructType\OrderDef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OrderDef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param OrderDef[] $orderDef
     * @return ArrayOfOrderDef
     * @throws InvalidArgumentException
     */
    public function setOrderDef(array $orderDef = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDefArrayErrorMessage = self::validateOrderDefForArrayConstraintsFromSetOrderDef($orderDef))) {
            throw new InvalidArgumentException($orderDefArrayErrorMessage, __LINE__);
        }
        if (is_null($orderDef) || (is_array($orderDef) && empty($orderDef))) {
            unset($this->OrderDef);
        } else {
            $this->OrderDef = $orderDef;
        }
        return $this;
    }

    /**
     * Add item to OrderDef value
     * @param OrderDef $item
     * @return ArrayOfOrderDef
     * @throws InvalidArgumentException
     */
    public function addToOrderDef(OrderDef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrderDef) {
            throw new InvalidArgumentException(sprintf('The OrderDef property can only contain items of type \Gek\UyumBahce\StructType\OrderDef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderDef[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return OrderDef|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return OrderDef|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return OrderDef|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return OrderDef|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return OrderDef|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string OrderDef
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'OrderDef';
    }
}
