<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\ItemDetailDef;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemDetailDef ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemDetailDef extends AbstractStructArrayBase
{
    /**
     * The ItemDetailDef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ItemDetailDef[]
     */
    public $ItemDetailDef;

    /**
     * Constructor method for ArrayOfItemDetailDef
     * @param ItemDetailDef[] $itemDetailDef
     * @uses ArrayOfItemDetailDef::setItemDetailDef()
     */
    public function __construct(array $itemDetailDef = array())
    {
        $this
            ->setItemDetailDef($itemDetailDef);
    }

    /**
     * Get ItemDetailDef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ItemDetailDef[]|null
     */
    public function getItemDetailDef()
    {
        return isset($this->ItemDetailDef) ? $this->ItemDetailDef : null;
    }

    /**
     * This method is responsible for validating the values passed to the setItemDetailDef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDetailDef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemDetailDefForArrayConstraintsFromSetItemDetailDef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemDetailDefItemDetailDefItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemDetailDefItemDetailDefItem instanceof ItemDetailDef) {
                $invalidValues[] = is_object($arrayOfItemDetailDefItemDetailDefItem) ? get_class($arrayOfItemDetailDefItemDetailDefItem) : sprintf('%s(%s)', gettype($arrayOfItemDetailDefItemDetailDefItem), var_export($arrayOfItemDetailDefItemDetailDefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemDetailDef property can only contain items of type \Gek\UyumBahce\StructType\ItemDetailDef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ItemDetailDef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ItemDetailDef[] $itemDetailDef
     * @return ArrayOfItemDetailDef
     * @throws InvalidArgumentException
     */
    public function setItemDetailDef(array $itemDetailDef = array())
    {
        // validation for constraint: array
        if ('' !== ($itemDetailDefArrayErrorMessage = self::validateItemDetailDefForArrayConstraintsFromSetItemDetailDef($itemDetailDef))) {
            throw new InvalidArgumentException($itemDetailDefArrayErrorMessage, __LINE__);
        }
        if (is_null($itemDetailDef) || (is_array($itemDetailDef) && empty($itemDetailDef))) {
            unset($this->ItemDetailDef);
        } else {
            $this->ItemDetailDef = $itemDetailDef;
        }
        return $this;
    }

    /**
     * Add item to ItemDetailDef value
     * @param ItemDetailDef $item
     * @return ArrayOfItemDetailDef
     * @throws InvalidArgumentException
     */
    public function addToItemDetailDef(ItemDetailDef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemDetailDef) {
            throw new InvalidArgumentException(sprintf('The ItemDetailDef property can only contain items of type \Gek\UyumBahce\StructType\ItemDetailDef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemDetailDef[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return ItemDetailDef|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return ItemDetailDef|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return ItemDetailDef|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return ItemDetailDef|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return ItemDetailDef|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string ItemDetailDef
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'ItemDetailDef';
    }
}
