<?php

namespace Gek\UyumBahce\StructType;

use DOMDocument;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for X509DataType StructType
 * @subpackage Structs
 */
class X509DataType extends AbstractStructBase
{
    /**
     * The X509CRL
     * Meta information extracted from the WSDL
     * - choice: X509CRL | X509Certificate | X509IssuerSerial | X509SKI | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $X509CRL;
    /**
     * The X509Certificate
     * Meta information extracted from the WSDL
     * - choice: X509CRL | X509Certificate | X509IssuerSerial | X509SKI | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $X509Certificate;
    /**
     * The X509IssuerSerial
     * Meta information extracted from the WSDL
     * - choice: X509CRL | X509Certificate | X509IssuerSerial | X509SKI | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var X509IssuerSerialType[]
     */
    public $X509IssuerSerial;
    /**
     * The X509SKI
     * Meta information extracted from the WSDL
     * - choice: X509CRL | X509Certificate | X509IssuerSerial | X509SKI | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $X509SKI;
    /**
     * The X509SubjectName
     * Meta information extracted from the WSDL
     * - choice: X509CRL | X509Certificate | X509IssuerSerial | X509SKI | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $X509SubjectName;
    /**
     * The any
     * @var DOMDocument
     */
    public $any;

    /**
     * Constructor method for X509DataType
     * @param string[] $x509CRL
     * @param string[] $x509Certificate
     * @param X509IssuerSerialType[] $x509IssuerSerial
     * @param string[] $x509SKI
     * @param string[] $x509SubjectName
     * @param DOMDocument $any
     * @uses X509DataType::setX509CRL()
     * @uses X509DataType::setX509Certificate()
     * @uses X509DataType::setX509IssuerSerial()
     * @uses X509DataType::setX509SKI()
     * @uses X509DataType::setX509SubjectName()
     * @uses X509DataType::setAny()
     */
    public function __construct(array $x509CRL = array(), array $x509Certificate = array(), array $x509IssuerSerial = array(), array $x509SKI = array(), array $x509SubjectName = array(), DOMDocument $any = null)
    {
        $this
            ->setX509CRL($x509CRL)
            ->setX509Certificate($x509Certificate)
            ->setX509IssuerSerial($x509IssuerSerial)
            ->setX509SKI($x509SKI)
            ->setX509SubjectName($x509SubjectName)
            ->setAny($any);
    }

    /**
     * Get X509CRL value
     * @return string[]|null
     */
    public function getX509CRL()
    {
        return isset($this->X509CRL) ? $this->X509CRL : null;
    }

    /**
     * This method is responsible for validating the values passed to the setX509CRL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509CRL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateX509CRLForArrayConstraintsFromSetX509CRL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $x509DataTypeX509CRLItem) {
            // validation for constraint: itemType
            if (!is_string($x509DataTypeX509CRLItem)) {
                $invalidValues[] = is_object($x509DataTypeX509CRLItem) ? get_class($x509DataTypeX509CRLItem) : sprintf('%s(%s)', gettype($x509DataTypeX509CRLItem), var_export($x509DataTypeX509CRLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The X509CRL property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setX509CRL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509CRL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509CRLForChoiceConstraintsFromSetX509CRL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509Certificate',
            'X509IssuerSerial',
            'X509SKI',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509CRL can\'t be set as the property %s is already set. Only one property must be set among these properties: X509CRL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set X509CRL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $x509CRL
     * @return X509DataType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setX509CRL(array $x509CRL = array())
    {
        // validation for constraint: array
        if ('' !== ($x509CRLArrayErrorMessage = self::validateX509CRLForArrayConstraintsFromSetX509CRL($x509CRL))) {
            throw new InvalidArgumentException($x509CRLArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($x509CRLChoiceErrorMessage = self::validateX509CRLForChoiceConstraintsFromSetX509CRL($x509CRL))) {
            throw new InvalidArgumentException($x509CRLChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($x509CRL) && count($x509CRL) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($x509CRL)), __LINE__);
        }
        if (is_null($x509CRL) || (is_array($x509CRL) && empty($x509CRL))) {
            unset($this->X509CRL);
        } else {
            $this->X509CRL = $x509CRL;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToX509CRL method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToX509CRL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToX509CRL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509Certificate',
            'X509IssuerSerial',
            'X509SKI',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509CRL can\'t be set as the property %s is already set. Only one property must be set among these properties: X509CRL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to X509CRL value
     * @param string $item
     * @return X509DataType
     * @throws InvalidArgumentException
     */
    public function addToX509CRL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The X509CRL property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToX509CRL($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->X509CRL) && count($this->X509CRL) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->X509CRL)), __LINE__);
        }
        $this->X509CRL[] = $item;
        return $this;
    }

    /**
     * Get X509Certificate value
     * @return string[]|null
     */
    public function getX509Certificate()
    {
        return isset($this->X509Certificate) ? $this->X509Certificate : null;
    }

    /**
     * This method is responsible for validating the values passed to the setX509Certificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509Certificate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateX509CertificateForArrayConstraintsFromSetX509Certificate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $x509DataTypeX509CertificateItem) {
            // validation for constraint: itemType
            if (!is_string($x509DataTypeX509CertificateItem)) {
                $invalidValues[] = is_object($x509DataTypeX509CertificateItem) ? get_class($x509DataTypeX509CertificateItem) : sprintf('%s(%s)', gettype($x509DataTypeX509CertificateItem), var_export($x509DataTypeX509CertificateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The X509Certificate property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setX509Certificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509Certificate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509CertificateForChoiceConstraintsFromSetX509Certificate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509IssuerSerial',
            'X509SKI',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509Certificate can\'t be set as the property %s is already set. Only one property must be set among these properties: X509Certificate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set X509Certificate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $x509Certificate
     * @return X509DataType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setX509Certificate(array $x509Certificate = array())
    {
        // validation for constraint: array
        if ('' !== ($x509CertificateArrayErrorMessage = self::validateX509CertificateForArrayConstraintsFromSetX509Certificate($x509Certificate))) {
            throw new InvalidArgumentException($x509CertificateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($x509CertificateChoiceErrorMessage = self::validateX509CertificateForChoiceConstraintsFromSetX509Certificate($x509Certificate))) {
            throw new InvalidArgumentException($x509CertificateChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($x509Certificate) && count($x509Certificate) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($x509Certificate)), __LINE__);
        }
        if (is_null($x509Certificate) || (is_array($x509Certificate) && empty($x509Certificate))) {
            unset($this->X509Certificate);
        } else {
            $this->X509Certificate = $x509Certificate;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToX509Certificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToX509Certificate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToX509Certificate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509IssuerSerial',
            'X509SKI',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509Certificate can\'t be set as the property %s is already set. Only one property must be set among these properties: X509Certificate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to X509Certificate value
     * @param string $item
     * @return X509DataType
     * @throws InvalidArgumentException
     */
    public function addToX509Certificate($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The X509Certificate property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToX509Certificate($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->X509Certificate) && count($this->X509Certificate) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->X509Certificate)), __LINE__);
        }
        $this->X509Certificate[] = $item;
        return $this;
    }

    /**
     * Get X509IssuerSerial value
     * @return X509IssuerSerialType[]|null
     */
    public function getX509IssuerSerial()
    {
        return isset($this->X509IssuerSerial) ? $this->X509IssuerSerial : null;
    }

    /**
     * This method is responsible for validating the values passed to the setX509IssuerSerial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509IssuerSerial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateX509IssuerSerialForArrayConstraintsFromSetX509IssuerSerial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $x509DataTypeX509IssuerSerialItem) {
            // validation for constraint: itemType
            if (!$x509DataTypeX509IssuerSerialItem instanceof X509IssuerSerialType) {
                $invalidValues[] = is_object($x509DataTypeX509IssuerSerialItem) ? get_class($x509DataTypeX509IssuerSerialItem) : sprintf('%s(%s)', gettype($x509DataTypeX509IssuerSerialItem), var_export($x509DataTypeX509IssuerSerialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The X509IssuerSerial property can only contain items of type \Gek\UyumBahce\StructType\X509IssuerSerialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setX509IssuerSerial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509IssuerSerial method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509IssuerSerialForChoiceConstraintsFromSetX509IssuerSerial($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509Certificate',
            'X509SKI',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509IssuerSerial can\'t be set as the property %s is already set. Only one property must be set among these properties: X509IssuerSerial, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set X509IssuerSerial value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param X509IssuerSerialType[] $x509IssuerSerial
     * @return X509DataType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setX509IssuerSerial(array $x509IssuerSerial = array())
    {
        // validation for constraint: array
        if ('' !== ($x509IssuerSerialArrayErrorMessage = self::validateX509IssuerSerialForArrayConstraintsFromSetX509IssuerSerial($x509IssuerSerial))) {
            throw new InvalidArgumentException($x509IssuerSerialArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($x509IssuerSerialChoiceErrorMessage = self::validateX509IssuerSerialForChoiceConstraintsFromSetX509IssuerSerial($x509IssuerSerial))) {
            throw new InvalidArgumentException($x509IssuerSerialChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($x509IssuerSerial) && count($x509IssuerSerial) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($x509IssuerSerial)), __LINE__);
        }
        if (is_null($x509IssuerSerial) || (is_array($x509IssuerSerial) && empty($x509IssuerSerial))) {
            unset($this->X509IssuerSerial);
        } else {
            $this->X509IssuerSerial = $x509IssuerSerial;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToX509IssuerSerial method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToX509IssuerSerial method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToX509IssuerSerial($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509Certificate',
            'X509SKI',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509IssuerSerial can\'t be set as the property %s is already set. Only one property must be set among these properties: X509IssuerSerial, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to X509IssuerSerial value
     * @param X509IssuerSerialType $item
     * @return X509DataType
     * @throws InvalidArgumentException
     */
    public function addToX509IssuerSerial(X509IssuerSerialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof X509IssuerSerialType) {
            throw new InvalidArgumentException(sprintf('The X509IssuerSerial property can only contain items of type \Gek\UyumBahce\StructType\X509IssuerSerialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToX509IssuerSerial($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->X509IssuerSerial) && count($this->X509IssuerSerial) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->X509IssuerSerial)), __LINE__);
        }
        $this->X509IssuerSerial[] = $item;
        return $this;
    }

    /**
     * Get X509SKI value
     * @return string[]|null
     */
    public function getX509SKI()
    {
        return isset($this->X509SKI) ? $this->X509SKI : null;
    }

    /**
     * This method is responsible for validating the values passed to the setX509SKI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509SKI method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateX509SKIForArrayConstraintsFromSetX509SKI(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $x509DataTypeX509SKIItem) {
            // validation for constraint: itemType
            if (!is_string($x509DataTypeX509SKIItem)) {
                $invalidValues[] = is_object($x509DataTypeX509SKIItem) ? get_class($x509DataTypeX509SKIItem) : sprintf('%s(%s)', gettype($x509DataTypeX509SKIItem), var_export($x509DataTypeX509SKIItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The X509SKI property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setX509SKI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509SKI method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509SKIForChoiceConstraintsFromSetX509SKI($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509Certificate',
            'X509IssuerSerial',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509SKI can\'t be set as the property %s is already set. Only one property must be set among these properties: X509SKI, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set X509SKI value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $x509SKI
     * @return X509DataType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setX509SKI(array $x509SKI = array())
    {
        // validation for constraint: array
        if ('' !== ($x509SKIArrayErrorMessage = self::validateX509SKIForArrayConstraintsFromSetX509SKI($x509SKI))) {
            throw new InvalidArgumentException($x509SKIArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($x509SKIChoiceErrorMessage = self::validateX509SKIForChoiceConstraintsFromSetX509SKI($x509SKI))) {
            throw new InvalidArgumentException($x509SKIChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($x509SKI) && count($x509SKI) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($x509SKI)), __LINE__);
        }
        if (is_null($x509SKI) || (is_array($x509SKI) && empty($x509SKI))) {
            unset($this->X509SKI);
        } else {
            $this->X509SKI = $x509SKI;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToX509SKI method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToX509SKI method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToX509SKI($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509Certificate',
            'X509IssuerSerial',
            'X509SubjectName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509SKI can\'t be set as the property %s is already set. Only one property must be set among these properties: X509SKI, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to X509SKI value
     * @param string $item
     * @return X509DataType
     * @throws InvalidArgumentException
     */
    public function addToX509SKI($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The X509SKI property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToX509SKI($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->X509SKI) && count($this->X509SKI) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->X509SKI)), __LINE__);
        }
        $this->X509SKI[] = $item;
        return $this;
    }

    /**
     * Get X509SubjectName value
     * @return string[]|null
     */
    public function getX509SubjectName()
    {
        return isset($this->X509SubjectName) ? $this->X509SubjectName : null;
    }

    /**
     * This method is responsible for validating the values passed to the setX509SubjectName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509SubjectName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateX509SubjectNameForArrayConstraintsFromSetX509SubjectName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $x509DataTypeX509SubjectNameItem) {
            // validation for constraint: itemType
            if (!is_string($x509DataTypeX509SubjectNameItem)) {
                $invalidValues[] = is_object($x509DataTypeX509SubjectNameItem) ? get_class($x509DataTypeX509SubjectNameItem) : sprintf('%s(%s)', gettype($x509DataTypeX509SubjectNameItem), var_export($x509DataTypeX509SubjectNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The X509SubjectName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setX509SubjectName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509SubjectName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509SubjectNameForChoiceConstraintsFromSetX509SubjectName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509Certificate',
            'X509IssuerSerial',
            'X509SKI',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509SubjectName can\'t be set as the property %s is already set. Only one property must be set among these properties: X509SubjectName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set X509SubjectName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $x509SubjectName
     * @return X509DataType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setX509SubjectName(array $x509SubjectName = array())
    {
        // validation for constraint: array
        if ('' !== ($x509SubjectNameArrayErrorMessage = self::validateX509SubjectNameForArrayConstraintsFromSetX509SubjectName($x509SubjectName))) {
            throw new InvalidArgumentException($x509SubjectNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($x509SubjectNameChoiceErrorMessage = self::validateX509SubjectNameForChoiceConstraintsFromSetX509SubjectName($x509SubjectName))) {
            throw new InvalidArgumentException($x509SubjectNameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($x509SubjectName) && count($x509SubjectName) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($x509SubjectName)), __LINE__);
        }
        if (is_null($x509SubjectName) || (is_array($x509SubjectName) && empty($x509SubjectName))) {
            unset($this->X509SubjectName);
        } else {
            $this->X509SubjectName = $x509SubjectName;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToX509SubjectName method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToX509SubjectName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToX509SubjectName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509CRL',
            'X509Certificate',
            'X509IssuerSerial',
            'X509SKI',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509SubjectName can\'t be set as the property %s is already set. Only one property must be set among these properties: X509SubjectName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to X509SubjectName value
     * @param string $item
     * @return X509DataType
     * @throws InvalidArgumentException
     */
    public function addToX509SubjectName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The X509SubjectName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(X509CRL, X509Certificate, X509IssuerSerial, X509SKI, X509SubjectName, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToX509SubjectName($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->X509SubjectName) && count($this->X509SubjectName) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->X509SubjectName)), __LINE__);
        }
        $this->X509SubjectName[] = $item;
        return $this;
    }

    /**
     * Get any value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }

    /**
     * Set any value
     * @param DOMDocument $any
     * @return X509DataType
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setAny(DOMDocument $any = null)
    {
        $this->any = ($any instanceof DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
