<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UyumServiceRequestOfItemBarcodeDef StructType
 * @subpackage Structs
 */
class UyumServiceRequestOfItemBarcodeDef extends AbstractStructBase
{
    /**
     * The Top
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Top;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UyumToken
     */
    public $Token;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ItemBarcodeDef
     */
    public $Value;

    /**
     * Constructor method for UyumServiceRequestOfItemBarcodeDef
     * @param int $top
     * @param int $pageIndex
     * @param int $pageSize
     * @param UyumToken $token
     * @param ItemBarcodeDef $value
     * @uses UyumServiceRequestOfItemBarcodeDef::setTop()
     * @uses UyumServiceRequestOfItemBarcodeDef::setPageIndex()
     * @uses UyumServiceRequestOfItemBarcodeDef::setPageSize()
     * @uses UyumServiceRequestOfItemBarcodeDef::setToken()
     * @uses UyumServiceRequestOfItemBarcodeDef::setValue()
     */
    public function __construct($top = null, $pageIndex = null, $pageSize = null, UyumToken $token = null, ItemBarcodeDef $value = null)
    {
        $this
            ->setTop($top)
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setToken($token)
            ->setValue($value);
    }

    /**
     * Get Top value
     * @return int
     */
    public function getTop()
    {
        return $this->Top;
    }

    /**
     * Set Top value
     * @param int $top
     * @return UyumServiceRequestOfItemBarcodeDef
     */
    public function setTop($top = null)
    {
        // validation for constraint: int
        if (!is_null($top) && !(is_int($top) || ctype_digit($top))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($top, true), gettype($top)), __LINE__);
        }
        $this->Top = $top;
        return $this;
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return UyumServiceRequestOfItemBarcodeDef
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }

    /**
     * Set PageSize value
     * @param int $pageSize
     * @return UyumServiceRequestOfItemBarcodeDef
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }

    /**
     * Get Token value
     * @return UyumToken|null
     */
    public function getToken()
    {
        return $this->Token;
    }

    /**
     * Set Token value
     * @param UyumToken $token
     * @return UyumServiceRequestOfItemBarcodeDef
     */
    public function setToken(UyumToken $token = null)
    {
        $this->Token = $token;
        return $this;
    }

    /**
     * Get Value value
     * @return ItemBarcodeDef|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param ItemBarcodeDef $value
     * @return UyumServiceRequestOfItemBarcodeDef
     */
    public function setValue(ItemBarcodeDef $value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
