<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextType StructType
 * @subpackage Structs
 */
class TextType extends AbstractStructBase
{
    /**
     * The _
     * @var TextType
     */
    public $_;
    /**
     * The languageID
     * @var string
     */
    public $languageID;
    /**
     * The languageLocaleID
     * @var string
     */
    public $languageLocaleID;

    /**
     * Constructor method for TextType
     * @param string|null $_
     * @param string $languageID
     * @param string $languageLocaleID
     * @uses TextType::set_()
     * @uses TextType::setLanguageID()
     * @uses TextType::setLanguageLocaleID()
     */
    public function __construct(?string $_ = null, $languageID = null, $languageLocaleID = null)
    {
        $this
            ->set_($_)
            ->setLanguageID($languageID)
            ->setLanguageLocaleID($languageLocaleID);
    }

    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }

    /**
     * Set _ value
     * @param string|null $_
     * @return TextType
     */
    public function set_(?string $_ = null)
    {
        $this->_ = $_;
        return $this;
    }

    /**
     * Get languageID value
     * @return string|null
     */
    public function getLanguageID()
    {
        return $this->languageID;
    }

    /**
     * Set languageID value
     * @param string $languageID
     * @return TextType
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: string
        if (!is_null($languageID) && !is_string($languageID)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageID, true), gettype($languageID)), __LINE__);
        }
        $this->languageID = $languageID;
        return $this;
    }

    /**
     * Get languageLocaleID value
     * @return string|null
     */
    public function getLanguageLocaleID()
    {
        return $this->languageLocaleID;
    }

    /**
     * Set languageLocaleID value
     * @param string $languageLocaleID
     * @return TextType
     */
    public function setLanguageLocaleID($languageLocaleID = null)
    {
        // validation for constraint: string
        if (!is_null($languageLocaleID) && !is_string($languageLocaleID)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageLocaleID, true), gettype($languageLocaleID)), __LINE__);
        }
        $this->languageLocaleID = $languageLocaleID;
        return $this;
    }
}
