<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureType StructType
 * @subpackage Structs
 */
class TemperatureType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AttributeID
     * @var AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Measure
     * @var MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Description
     * @var DescriptionType[]
     */
    public $Description;

    /**
     * Constructor method for TemperatureType
     * @param AttributeIDType $attributeID
     * @param MeasureType $measure
     * @param DescriptionType[] $description
     * @uses TemperatureType::setAttributeID()
     * @uses TemperatureType::setMeasure()
     * @uses TemperatureType::setDescription()
     */
    public function __construct(AttributeIDType $attributeID = null, MeasureType $measure = null, array $description = array())
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description);
    }

    /**
     * Get AttributeID value
     * @return AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }

    /**
     * Set AttributeID value
     * @param AttributeIDType $attributeID
     * @return TemperatureType
     */
    public function setAttributeID(AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }

    /**
     * Get Measure value
     * @return MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }

    /**
     * Set Measure value
     * @param MeasureType $measure
     * @return TemperatureType
     */
    public function setMeasure(MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }

    /**
     * Get Description value
     * @return DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $temperatureTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$temperatureTypeDescriptionItem instanceof DescriptionType) {
                $invalidValues[] = is_object($temperatureTypeDescriptionItem) ? get_class($temperatureTypeDescriptionItem) : sprintf('%s(%s)', gettype($temperatureTypeDescriptionItem), var_export($temperatureTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Description value
     * @param DescriptionType[] $description
     * @return TemperatureType
     * @throws InvalidArgumentException
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }

    /**
     * Add item to Description value
     * @param DescriptionType $item
     * @return TemperatureType
     * @throws InvalidArgumentException
     */
    public function addToDescription(DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DescriptionType) {
            throw new InvalidArgumentException(sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
}
