<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfInt;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceResultOfListOfInt32 StructType
 * @subpackage Structs
 */
class ServiceResultOfListOfInt32 extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Result;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The TotalPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalPage;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfInt
     */
    public $Value;

    /**
     * Constructor method for ServiceResultOfListOfInt32
     * @param bool $result
     * @param int $pageIndex
     * @param int $totalPage
     * @param string $message
     * @param ArrayOfInt $value
     * @uses ServiceResultOfListOfInt32::setResult()
     * @uses ServiceResultOfListOfInt32::setPageIndex()
     * @uses ServiceResultOfListOfInt32::setTotalPage()
     * @uses ServiceResultOfListOfInt32::setMessage()
     * @uses ServiceResultOfListOfInt32::setValue()
     */
    public function __construct($result = null, $pageIndex = null, $totalPage = null, $message = null, ArrayOfInt $value = null)
    {
        $this
            ->setResult($result)
            ->setPageIndex($pageIndex)
            ->setTotalPage($totalPage)
            ->setMessage($message)
            ->setValue($value);
    }

    /**
     * Get Result value
     * @return bool
     */
    public function getResult()
    {
        return $this->Result;
    }

    /**
     * Set Result value
     * @param bool $result
     * @return ServiceResultOfListOfInt32
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return ServiceResultOfListOfInt32
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get TotalPage value
     * @return int
     */
    public function getTotalPage()
    {
        return $this->TotalPage;
    }

    /**
     * Set TotalPage value
     * @param int $totalPage
     * @return ServiceResultOfListOfInt32
     */
    public function setTotalPage($totalPage = null)
    {
        // validation for constraint: int
        if (!is_null($totalPage) && !(is_int($totalPage) || ctype_digit($totalPage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPage, true), gettype($totalPage)), __LINE__);
        }
        $this->TotalPage = $totalPage;
        return $this;
    }

    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * Set Message value
     * @param string $message
     * @return ServiceResultOfListOfInt32
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }

    /**
     * Get Value value
     * @return ArrayOfInt|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param ArrayOfInt $value
     * @return ServiceResultOfListOfInt32
     */
    public function setValue(ArrayOfInt $value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
